/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.internal.LogicalConnectionImpl;
import org.hibernate.engine.jdbc.internal.ResultSetReturnImpl;
import org.hibernate.engine.jdbc.internal.StatementPreparerImpl;
import org.hibernate.engine.jdbc.spi.InvalidatableWrapper;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.jboss.logging.Logger;

public class JdbcCoordinatorImpl
implements JdbcCoordinator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcCoordinatorImpl.class.getName());
    private transient TransactionCoordinator transactionCoordinator;
    private final transient LogicalConnectionImpl logicalConnection;
    private transient Batch currentBatch;
    private transient long transactionTimeOutInstant = -1L;
    private final HashMap<Statement, Set<ResultSet>> xref = new HashMap();
    private final Set<ResultSet> unassociatedResultSets = new HashSet<ResultSet>();
    private final SqlExceptionHelper exceptionHelper;
    private Statement lastQuery;
    private boolean releasesEnabled = true;
    private int flushDepth = 0;
    private transient StatementPreparer statementPreparer;
    private transient ResultSetReturn resultSetExtractor;

    public JdbcCoordinatorImpl(Connection userSuppliedConnection, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = new LogicalConnectionImpl(userSuppliedConnection, transactionCoordinator.getTransactionContext().getConnectionReleaseMode(), transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices(), transactionCoordinator.getTransactionContext().getJdbcConnectionAccess());
        this.exceptionHelper = this.logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    public JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnection, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = logicalConnection;
        this.exceptionHelper = logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    private JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnection) {
        this.logicalConnection = logicalConnection;
        this.exceptionHelper = logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public LogicalConnectionImplementor getLogicalConnection() {
        return this.logicalConnection;
    }

    protected TransactionEnvironment transactionEnvironment() {
        return this.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment();
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment().getSessionFactory();
    }

    protected BatchBuilder batchBuilder() {
        return this.sessionFactory().getServiceRegistry().getService(BatchBuilder.class);
    }

    public SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public void flushBeginning() {
        if (this.flushDepth == 0) {
            this.releasesEnabled = false;
        }
        ++this.flushDepth;
    }

    @Override
    public void flushEnding() {
        --this.flushDepth;
        if (this.flushDepth < 0) {
            throw new HibernateException("Mismatched flush handling");
        }
        if (this.flushDepth == 0) {
            this.releasesEnabled = true;
        }
        this.afterStatementExecution();
    }

    @Override
    public Connection close() {
        LOG.tracev("Closing JDBC container [{0}]", this);
        if (this.currentBatch != null) {
            LOG.closingUnreleasedBatch();
            this.currentBatch.release();
        }
        this.cleanup();
        return this.logicalConnection.close();
    }

    @Override
    public Batch getBatch(BatchKey key) {
        if (this.currentBatch != null) {
            if (this.currentBatch.getKey().equals(key)) {
                return this.currentBatch;
            }
            this.currentBatch.execute();
            this.currentBatch.release();
        }
        this.currentBatch = this.batchBuilder().buildBatch(key, this);
        return this.currentBatch;
    }

    @Override
    public void executeBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.execute();
            this.currentBatch.release();
        }
    }

    @Override
    public void abortBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.release();
        }
    }

    @Override
    public StatementPreparer getStatementPreparer() {
        if (this.statementPreparer == null) {
            this.statementPreparer = new StatementPreparerImpl(this);
        }
        return this.statementPreparer;
    }

    @Override
    public ResultSetReturn getResultSetReturn() {
        if (this.resultSetExtractor == null) {
            this.resultSetExtractor = new ResultSetReturnImpl(this);
        }
        return this.resultSetExtractor;
    }

    @Override
    public void setTransactionTimeOut(int seconds) {
        this.transactionTimeOutInstant = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    @Override
    public int determineRemainingTransactionTimeOutPeriod() {
        if (this.transactionTimeOutInstant < 0L) {
            return -1;
        }
        int secondsRemaining = (int)((this.transactionTimeOutInstant - System.currentTimeMillis()) / 1000L);
        if (secondsRemaining <= 0) {
            throw new TransactionException("transaction timeout expired");
        }
        return secondsRemaining;
    }

    @Override
    public void afterStatementExecution() {
        LOG.tracev("Starting after statement execution processing [{0}]", (Object)this.connectionReleaseMode());
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (!this.releasesEnabled) {
                LOG.debug("Skipping aggressive release due to manual disabling");
                return;
            }
            if (this.hasRegisteredResources()) {
                LOG.debug("Skipping aggressive release due to registered resources");
                return;
            }
            this.getLogicalConnection().releaseConnection();
        }
    }

    @Override
    public void afterTransaction() {
        this.transactionTimeOutInstant = -1L;
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT || this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION) {
            if (this.hasRegisteredResources()) {
                LOG.forcingContainerResourceCleanup();
                this.releaseResources();
            }
            this.getLogicalConnection().aggressiveRelease();
        }
    }

    private ConnectionReleaseMode connectionReleaseMode() {
        return this.getLogicalConnection().getConnectionReleaseMode();
    }

    @Override
    public <T> T coordinateWork(WorkExecutorVisitable<T> work) {
        Connection connection = this.getLogicalConnection().getConnection();
        try {
            T result = work.accept(new WorkExecutor(), connection);
            this.afterStatementExecution();
            return result;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "error executing work");
        }
    }

    @Override
    public boolean isReadyForSerialization() {
        return this.getLogicalConnection().isUserSuppliedConnection() ? !this.getLogicalConnection().isPhysicallyConnected() : !this.hasRegisteredResources();
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new HibernateException("Cannot serialize Session while connected");
        }
        this.logicalConnection.serialize(oos);
    }

    public static JdbcCoordinatorImpl deserialize(ObjectInputStream ois, TransactionContext transactionContext) throws IOException, ClassNotFoundException {
        return new JdbcCoordinatorImpl(LogicalConnectionImpl.deserialize(ois, transactionContext));
    }

    public void afterDeserialize(TransactionCoordinatorImpl transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    @Override
    public void register(Statement statement) {
        LOG.tracev("Registering statement [{0}]", statement);
        if (this.xref.containsKey(statement)) {
            throw new HibernateException("statement already registered with JDBCContainer");
        }
        this.xref.put(statement, null);
    }

    @Override
    public void registerLastQuery(Statement statement) {
        LOG.tracev("Registering last query statement [{0}]", statement);
        if (statement instanceof JdbcWrapper) {
            JdbcWrapper wrapper = (JdbcWrapper)((Object)statement);
            this.registerLastQuery((Statement)wrapper.getWrappedObject());
            return;
        }
        this.lastQuery = statement;
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw this.exceptionHelper.convert(sqle, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(Statement statement) {
        LOG.tracev("Releasing statement [{0}]", statement);
        Set<ResultSet> resultSets = this.xref.get(statement);
        if (resultSets != null) {
            for (ResultSet resultSet : resultSets) {
                this.close(resultSet);
            }
            resultSets.clear();
        }
        this.xref.remove(statement);
        this.close(statement);
        this.afterStatementExecution();
    }

    @Override
    public void register(ResultSet resultSet, Statement statement) {
        LOG.tracev("Registering result set [{0}]", resultSet);
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
            }
        }
        if (statement != null) {
            Set<ResultSet> resultSets;
            if (LOG.isEnabled(Logger.Level.WARN) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((resultSets = this.xref.get(statement)) == null) {
                resultSets = new HashSet<ResultSet>();
                this.xref.put(statement, resultSets);
            }
            resultSets.add(resultSet);
        } else {
            this.unassociatedResultSets.add(resultSet);
        }
    }

    @Override
    public void release(ResultSet resultSet) {
        Statement statement;
        LOG.tracev("Releasing result set [{0}]", resultSet);
        try {
            statement = resultSet.getStatement();
        }
        catch (SQLException e) {
            throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
        }
        if (statement != null) {
            Set<ResultSet> resultSets;
            if (LOG.isEnabled(Logger.Level.WARN) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((resultSets = this.xref.get(statement)) != null) {
                resultSets.remove(resultSet);
                if (resultSets.isEmpty()) {
                    this.xref.remove(statement);
                }
            }
        } else {
            boolean removed = this.unassociatedResultSets.remove(resultSet);
            if (!removed) {
                LOG.unregisteredResultSetWithoutStatement();
            }
        }
        this.close(resultSet);
    }

    @Override
    public boolean hasRegisteredResources() {
        return !this.xref.isEmpty() || !this.unassociatedResultSets.isEmpty();
    }

    @Override
    public void releaseResources() {
        LOG.tracev("Releasing JDBC container resources [{0}]", this);
        this.cleanup();
    }

    @Override
    public void enableReleases() {
        this.releasesEnabled = true;
    }

    @Override
    public void disableReleases() {
        this.releasesEnabled = false;
    }

    private void cleanup() {
        for (Map.Entry<Statement, Set<ResultSet>> entry : this.xref.entrySet()) {
            if (entry.getValue() != null) {
                this.closeAll(entry.getValue());
            }
            this.close(entry.getKey());
        }
        this.xref.clear();
        this.closeAll(this.unassociatedResultSets);
    }

    protected void closeAll(Set<ResultSet> resultSets) {
        for (ResultSet resultSet : resultSets) {
            this.close(resultSet);
        }
        resultSets.clear();
    }

    protected void close(Statement statement) {
        LOG.tracev("Closing prepared statement [{0}]", statement);
        if (statement instanceof InvalidatableWrapper) {
            InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)statement);
            this.close((Statement)wrapper.getWrappedObject());
            wrapper.invalidate();
            return;
        }
        try {
            try {
                if (statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
                if (statement.getQueryTimeout() != 0) {
                    statement.setQueryTimeout(0);
                }
            }
            catch (SQLException sqle) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Exception clearing maxRows/queryTimeout [%s]", sqle.getMessage());
                }
                return;
            }
            statement.close();
            if (this.lastQuery == statement) {
                this.lastQuery = null;
            }
        }
        catch (SQLException e) {
            LOG.debugf("Unable to release JDBC statement [%s]", e.getMessage());
        }
        catch (Exception e) {
            LOG.debugf("Unable to release JDBC statement [%s]", e.getMessage());
        }
    }

    protected void close(ResultSet resultSet) {
        LOG.tracev("Closing result set [{0}]", resultSet);
        if (resultSet instanceof InvalidatableWrapper) {
            InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)resultSet);
            this.close((ResultSet)wrapper.getWrappedObject());
            wrapper.invalidate();
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOG.debugf("Unable to release JDBC result set [%s]", e.getMessage());
        }
        catch (Exception e) {
            LOG.debugf("Unable to release JDBC result set [%s]", e.getMessage());
        }
    }
}

