/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.PrintStream;
import org.apache.maven.plugin.logging.Log;

class StreamLog
implements Log {
    static final int DEBUG = 0;
    static final int INFO = 1;
    static final int WARN = 2;
    static final int ERROR = 3;
    private int level = 1;
    private final PrintStream s;

    public void setLevel(int level) {
        if (level < 0 || level > 3) {
            throw new IllegalStateException("invalid level: " + level);
        }
        this.level = level;
    }

    StreamLog(PrintStream s) {
        this.s = s;
    }

    public void debug(CharSequence content) {
        if (this.isDebugEnabled()) {
            this.s.println(content);
        }
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.isDebugEnabled()) {
            this.s.println(content);
        }
    }

    public void debug(Throwable error) {
        if (this.isDebugEnabled()) {
            error.printStackTrace(this.s);
        }
    }

    public void error(CharSequence content) {
        if (this.isErrorEnabled()) {
            this.s.println(content);
        }
    }

    public void error(CharSequence content, Throwable error) {
        this.error(content);
        this.error(error);
    }

    public void error(Throwable error) {
        if (this.isErrorEnabled()) {
            error.printStackTrace(this.s);
        }
    }

    public void info(CharSequence content) {
        if (this.isInfoEnabled()) {
            this.s.println(content);
        }
    }

    public void info(CharSequence content, Throwable error) {
        this.info(content);
        this.info(error);
    }

    public void info(Throwable error) {
        if (this.isInfoEnabled()) {
            error.printStackTrace(this.s);
        }
    }

    public boolean isDebugEnabled() {
        return this.level >= 0;
    }

    public boolean isErrorEnabled() {
        return this.level >= 3;
    }

    public boolean isInfoEnabled() {
        return this.level >= 1;
    }

    public boolean isWarnEnabled() {
        return this.level >= 2;
    }

    public void warn(CharSequence content) {
        if (this.isWarnEnabled()) {
            this.s.println(content);
        }
    }

    public void warn(CharSequence content, Throwable error) {
        this.warn(content);
        this.warn(error);
    }

    public void warn(Throwable error) {
        if (this.isWarnEnabled()) {
            error.printStackTrace(this.s);
        }
    }
}

