/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationLogs;
import org.cloudfoundry.client.lib.rest.LoggregatorMessageParser;
import org.cloudfoundry.client.lib.util.Multipart;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class LoggregatorHttpMessageConverter
extends AbstractHttpMessageConverter<ApplicationLogs> {
    private LoggregatorMessageParser messageParser = new LoggregatorMessageParser();

    public LoggregatorHttpMessageConverter() {
        super(new MediaType("multipart", "x-protobuf"));
    }

    protected boolean supports(Class<?> clazz) {
        return ApplicationLogs.class.equals(clazz);
    }

    public boolean canWrite(MediaType mediaType) {
        return false;
    }

    protected ApplicationLogs readInternal(Class<? extends ApplicationLogs> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Multipart.Part part;
        String boundary = this.getMessageBoundary(inputMessage);
        Multipart multipart = new Multipart(inputMessage.getBody(), boundary);
        ApplicationLogs logs = new ApplicationLogs();
        while ((part = multipart.nextPart()) != null) {
            ApplicationLog log = this.messageParser.parseMessage(part.getContent());
            logs.add(log);
        }
        return logs;
    }

    protected void writeInternal(ApplicationLogs logs, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        throw new UnsupportedOperationException("Writing to LoggregatorHttpMessageConverter is not supported");
    }

    private String getMessageBoundary(HttpInputMessage inputMessage) {
        MediaType mediaType = inputMessage.getHeaders().getContentType();
        Map parameters = mediaType.getParameters();
        return (String)parameters.get("boundary");
    }
}

