/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.RestLogEntry;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class LoggingRestTemplate
extends RestTemplate {
    private Set<RestLogCallback> listeners = new LinkedHashSet<RestLogCallback>();

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, final ResponseExtractor<T> responseExtractor) throws RestClientException {
        RestClientException exception;
        Object results;
        String[] message;
        HttpStatus[] httpStatus;
        String[] status;
        block3: {
            status = new String[1];
            httpStatus = new HttpStatus[1];
            final Object[] headers = new Object[1];
            message = new String[1];
            results = null;
            exception = null;
            try {
                results = super.doExecute(url, method, requestCallback, new ResponseExtractor<T>(){

                    public T extractData(ClientHttpResponse response) throws IOException {
                        httpStatus[0] = response.getStatusCode();
                        headers[0] = response.getHeaders();
                        Object data = null;
                        if (responseExtractor != null && (data = responseExtractor.extractData(response)) != null) {
                            message[0] = data instanceof String ? ((String)data).length() + " bytes" : (data instanceof Map ? ((Map)data).keySet().toString() : data.getClass().getName());
                            return data;
                        }
                        message[0] = "<no data>";
                        return null;
                    }
                });
                status[0] = "OK";
            }
            catch (RestClientException e) {
                status[0] = "ERROR";
                message[0] = e.getMessage();
                exception = e;
                if (!(e instanceof HttpStatusCodeException)) break block3;
                httpStatus[0] = ((HttpStatusCodeException)e).getStatusCode();
            }
        }
        this.addLogMessage(method, url, status[0], httpStatus[0], message[0]);
        if (exception != null) {
            throw exception;
        }
        return (T)results;
    }

    public void addLogMessage(HttpMethod method, URI url, String status, HttpStatus httpStatus, String message) {
        RestLogEntry logEntry = new RestLogEntry(method, url, status, httpStatus, message);
        for (RestLogCallback callback : this.listeners) {
            callback.onNewLogEntry(logEntry);
        }
    }

    void registerRestLogListener(RestLogCallback callBack) {
        if (callBack != null) {
            this.listeners.add(callBack);
        }
    }

    void unRegisterRestLogListener(RestLogCallback callBack) {
        this.listeners.remove(callBack);
    }
}

