/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.identity.security;

import org.beast.user.core.AuthenticationKey;

public class UserAuthentication {
    private String appId;
    private Long uid;
    private AuthenticationKey authenticationKey;
    private String identifier;

    UserAuthentication(String appId, Long uid, AuthenticationKey authenticationKey, String identifier) {
        this.appId = appId;
        this.uid = uid;
        this.authenticationKey = authenticationKey;
        this.identifier = identifier;
    }

    public static UserAuthenticationBuilder builder() {
        return new UserAuthenticationBuilder();
    }

    public String toString() {
        return "UserAuthentication(appId=" + this.getAppId() + ", uid=" + this.getUid() + ", authenticationKey=" + this.getAuthenticationKey() + ", identifier=" + this.getIdentifier() + ")";
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getUid() {
        return this.uid;
    }

    public AuthenticationKey getAuthenticationKey() {
        return this.authenticationKey;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static class UserAuthenticationBuilder {
        private String appId;
        private Long uid;
        private AuthenticationKey authenticationKey;
        private String identifier;

        UserAuthenticationBuilder() {
        }

        public UserAuthenticationBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public UserAuthenticationBuilder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public UserAuthenticationBuilder authenticationKey(AuthenticationKey authenticationKey) {
            this.authenticationKey = authenticationKey;
            return this;
        }

        public UserAuthenticationBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public UserAuthentication build() {
            return new UserAuthentication(this.appId, this.uid, this.authenticationKey, this.identifier);
        }

        public String toString() {
            return "UserAuthentication.UserAuthenticationBuilder(appId=" + this.appId + ", uid=" + this.uid + ", authenticationKey=" + this.authenticationKey + ", identifier=" + this.identifier + ")";
        }
    }
}

