package org.beast.user.identity.security.channel;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.form.spring.SpringFormEncoder;
import feign.jackson.JacksonDecoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class IDCardAutoConfiguration {

    @Bean
    public EidClient eidClient(ObjectMapper objectMapper) {
        return Feign.builder()
                .contract(new SpringMvcContract())
                .requestInterceptor(new RequestInterceptor() {
                    @Override
                    public void apply(RequestTemplate requestTemplate) {
                        requestTemplate.header("Authorization", "APPCODE 7939f05c63414f31ae44a4ef74f21721");
                    }
                })
                .encoder(new SpringFormEncoder())
                .decoder(new JacksonDecoder(objectMapper))
                .target(EidClient.class, "https://eid.shumaidata.com");
    }
}
