package org.beast.user.identity.security.channel;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import org.springframework.web.bind.annotation.PostMapping;

public interface EidClient {

    @PostMapping(path = "/eid/check", consumes = "application/x-www-form-urlencoded")
    EidResult verify(
            NidCardInput input
//            @RequestParam("idcard") String idcard,
//            @RequestParam("name") String name
    );

    @Builder
    @Data
    public static class NidCardInput {
        private String idcard;
        private String name;
    }

    @ToString
    @Data
    public static class EidCheckOutput {
        private String name;
        private String idcard;
        private String address;
        private String sex;
        private String birthday;

    }

    @ToString
    @Data
    public static class EidResult {
        private String code;

        private String message;

        private EidCheckOutput result;

    }

}
