/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.data.configuration;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import org.beast.user.core.AuthenticationKey;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@Configuration
public class UserDataAutoConfiguration {
    @Bean
    public UserDataModule userDataModule() {
        return new UserDataModule();
    }

    public static class UserDataModule
    extends SimpleModule {
        public UserDataModule() {
            super("UserData");
            this.addSerializer(AuthenticationKey.class, (JsonSerializer)new ToStringSerializer(AuthenticationKey.class));
            this.addDeserializer(AuthenticationKey.class, (JsonDeserializer)new AuthenticationKeyDeserializer());
        }

        public static class AuthenticationKeyDeserializer
        extends FromStringDeserializer<AuthenticationKey> {
            protected AuthenticationKeyDeserializer() {
                super(AuthenticationKey.class);
            }

            protected AuthenticationKey _deserialize(String value, DeserializationContext deserializationContext) throws IOException {
                return AuthenticationKey.valueOf((String)value);
            }
        }
    }
}

