/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.data;

import java.time.Instant;
import java.util.Objects;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.IdentityType;

public class SecuredUserIdentity {
    private IdentityType identityType;
    private String group;
    private String identifier;
    private Instant createdAt;

    public SecuredUserIdentity() {
    }

    public boolean test(AuthenticationKey key) {
        return Objects.equals(key.getIdentityType(), this.identityType) && Objects.equals(key.getGroup(), this.group);
    }

    SecuredUserIdentity(IdentityType identityType, String group, String identifier, Instant createdAt) {
        this.identityType = identityType;
        this.group = group;
        this.identifier = identifier;
        this.createdAt = createdAt;
    }

    public static SecuredUserIdentityBuilder builder() {
        return new SecuredUserIdentityBuilder();
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public String getGroup() {
        return this.group;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecuredUserIdentity)) {
            return false;
        }
        SecuredUserIdentity other = (SecuredUserIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdentityType this$identityType = this.getIdentityType();
        IdentityType other$identityType = other.getIdentityType();
        if (this$identityType == null ? other$identityType != null : !this$identityType.equals(other$identityType)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecuredUserIdentity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdentityType $identityType = this.getIdentityType();
        result = result * 59 + ($identityType == null ? 43 : $identityType.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "SecuredUserIdentity(identityType=" + this.getIdentityType() + ", group=" + this.getGroup() + ", identifier=" + this.getIdentifier() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public static class SecuredUserIdentityBuilder {
        private IdentityType identityType;
        private String group;
        private String identifier;
        private Instant createdAt;

        SecuredUserIdentityBuilder() {
        }

        public SecuredUserIdentityBuilder identityType(IdentityType identityType) {
            this.identityType = identityType;
            return this;
        }

        public SecuredUserIdentityBuilder group(String group) {
            this.group = group;
            return this;
        }

        public SecuredUserIdentityBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public SecuredUserIdentityBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SecuredUserIdentity build() {
            return new SecuredUserIdentity(this.identityType, this.group, this.identifier, this.createdAt);
        }

        public String toString() {
            return "SecuredUserIdentity.SecuredUserIdentityBuilder(identityType=" + this.identityType + ", group=" + this.group + ", identifier=" + this.identifier + ", createdAt=" + this.createdAt + ")";
        }
    }
}

