package org.beast.user.data.configuration;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.beast.user.core.AuthenticationKey;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

@AutoConfigureBefore(JacksonAutoConfiguration.class)
@Configuration
public class UserDataAutoConfiguration {
    @Bean
    public UserDataModule userDataModule() {
        return new UserDataModule();
    }

//    @Bean
//    public MongoModule mongoModule() {
//        return new MongoModule();
//    }



    public static class UserDataModule extends SimpleModule {

        public UserDataModule() {
            super("UserData");
            this.addSerializer(AuthenticationKey.class, new ToStringSerializer(AuthenticationKey.class));
            this.addDeserializer(AuthenticationKey.class, new AuthenticationKeyDeserializer());
        }


        public static class AuthenticationKeyDeserializer extends FromStringDeserializer<AuthenticationKey> {

            protected AuthenticationKeyDeserializer() {
                super(AuthenticationKey.class);
            }

            @Override
            protected AuthenticationKey _deserialize(String value, DeserializationContext deserializationContext) throws IOException {
                return AuthenticationKey.valueOf(value);
            }
        }
    }
}
