package org.beast.user.data;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.IdentityType;

import java.time.Instant;
import java.util.Objects;

/**
 * 安全的用户信息
 * 15375717130 ==> 153****7130
 * => i****@i-firefly.com
 */

@Builder
@Data
public class SecuredUserIdentity {

    //身份类型
    private IdentityType identityType;

    //归组: 例如直接使用公众号appId
    private String group;

    //标示ID
    private String identifier;

    private Instant createdAt;


    @Tolerate
    public SecuredUserIdentity() {
    }

    public boolean test(AuthenticationKey key) {
        return Objects.equals(key.getIdentityType(), this.identityType) && Objects.equals(key.getGroup(), this.group);
    }
}
