/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.beast.security.core.AlipayAliappSNSToken;
import org.beast.security.core.AlipayAliappSNSUserToken;
import org.beast.security.core.BytedanceByteappSNSToken;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSToken;
import org.beast.security.core.SNSType;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatOffiaccountSNSToken;
import org.beast.security.core.WechatOffiaccountSNSUserToken;
import org.beast.security.core.WechatUnionSNSToken;
import org.beast.security.core.WechatUnionSNSUserToken;
import org.beast.security.core.WechatWeappSNSToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.WechatWebSNSToken;
import org.beast.user.config.UserApp;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.Identity;
import org.beast.user.core.IdentityType;

public class SNSIdentityUtils {
    public static String identifierOfSNSToken(SNSToken token) {
        SNSType type = token.getType();
        return switch (type) {
            case SNSType.WECHAT_WEB -> ((WechatWebSNSToken)token).getOpenid();
            case SNSType.WECHAT_OFFIACCOUNT -> ((WechatOffiaccountSNSToken)token).getOpenid();
            case SNSType.WECHAT_WEAPP -> ((WechatWeappSNSToken)token).getOpenid();
            case SNSType.WECHAT_UNION -> ((WechatUnionSNSToken)token).getUnionId();
            case SNSType.ALIPAY_ALIAPP -> ((AlipayAliappSNSToken)token).getUserId();
            case SNSType.BYTEDANCE_BYTEAPP -> ((BytedanceByteappSNSToken)token).getOpenid();
            default -> throw new IllegalArgumentException("No matching type [" + type + "]");
        };
    }

    public static String identifierOfSNSToken(SNSUserToken token) {
        SNSType type = token.getType();
        return switch (type) {
            case SNSType.WECHAT_OFFIACCOUNT -> ((WechatOffiaccountSNSUserToken)token).getOpenid();
            case SNSType.WECHAT_WEAPP -> ((WechatWeappSNSUserToken)token).getOpenid();
            case SNSType.WECHAT_UNION -> ((WechatUnionSNSUserToken)token).getUnionId();
            case SNSType.ALIPAY_ALIAPP -> ((AlipayAliappSNSUserToken)token).getUserId();
            case SNSType.BYTEDANCE_BYTEAPP -> ((BytedanceByteappSNSUserToken)token).getOpenid();
            default -> throw new IllegalArgumentException("No matching type [" + type + "]");
        };
    }

    public static SNSType typeOfIdentityType(IdentityType identityType) {
        return switch (identityType) {
            case IdentityType.WECHAT_WEB -> SNSType.WECHAT_WEB;
            case IdentityType.WECHAT_OFFIACCOUNT -> SNSType.WECHAT_OFFIACCOUNT;
            case IdentityType.WECHAT_WEAPP -> SNSType.WECHAT_WEAPP;
            case IdentityType.WECHAT_UNION -> SNSType.WECHAT_UNION;
            case IdentityType.ALIPAY_ALIAPP -> SNSType.ALIPAY_ALIAPP;
            case IdentityType.BYTEDANCE_BYTEAPP -> SNSType.BYTEDANCE_BYTEAPP;
            default -> throw new IllegalArgumentException("No matching type [" + identityType + "]");
        };
    }

    public static IdentityType identityTypeOfSNSType(SNSType type) {
        return switch (type) {
            case SNSType.WECHAT_WEB -> IdentityType.WECHAT_WEB;
            case SNSType.WECHAT_OFFIACCOUNT -> IdentityType.WECHAT_OFFIACCOUNT;
            case SNSType.WECHAT_WEAPP -> IdentityType.WECHAT_WEAPP;
            case SNSType.WECHAT_UNION -> IdentityType.WECHAT_UNION;
            case SNSType.ALIPAY_ALIAPP -> IdentityType.ALIPAY_ALIAPP;
            case SNSType.BYTEDANCE_BYTEAPP -> IdentityType.BYTEDANCE_BYTEAPP;
            default -> throw new IllegalArgumentException("No matching type [" + type + "]");
        };
    }

    public static Identity identityOfAuthenticationKeyAndToken(AuthenticationKey authenticationKey, SNSToken snsToken) {
        IdentityType identityType = SNSIdentityUtils.identityTypeOfSNSType(snsToken.getType());
        if (!authenticationKey.isIdentityType(identityType)) {
            throw new IllegalStateException(String.format("authenticationKey [%s] unable resolve token type: [%s] ", authenticationKey, snsToken.getType()));
        }
        return new Identity(identityType, authenticationKey.getGroup(), SNSIdentityUtils.identifierOfSNSToken(snsToken));
    }

    public static Identity identityOfAuthenticationKeyAndToken(AuthenticationKey authenticationKey, SNSUserToken token) {
        IdentityType identityType = SNSIdentityUtils.identityTypeOfSNSType(token.getType());
        if (!authenticationKey.isIdentityType(identityType)) {
            throw new IllegalStateException(String.format("authenticationKey [%s] unable resolve token type: [%s] ", authenticationKey, token.getType()));
        }
        return new Identity(identityType, authenticationKey.getGroup(), SNSIdentityUtils.identifierOfSNSToken(token));
    }

    public static boolean support(IdentityType identityType) {
        for (SNSType value : SNSType.values()) {
            if (!Objects.equals(value.name(), identityType.name())) continue;
            return true;
        }
        return false;
    }

    public static List<Identity> identityOfUserAppKeySNSIdentity(UserApp app, AuthenticationKey authenticationKey, SNSUserToken token) {
        SNSType type = token.getType();
        ArrayList identities = Lists.newArrayList((Object[])new Identity[]{SNSIdentityUtils.identityOfAuthenticationKeyAndToken(authenticationKey, token)});
        switch (type) {
            case WECHAT_WEAPP: {
                WechatWeappSNSUserToken weappSNSToken = (WechatWeappSNSUserToken)token;
                String unionId = weappSNSToken.getUnionId();
                if (!Objects.nonNull(unionId)) break;
                String unionKey = app.lookupUnionKey(authenticationKey);
                Identity unionIdentity = Identity.valueOf((AuthenticationKey)AuthenticationKey.valueOf((IdentityType)IdentityType.WECHAT_UNION, (String)unionKey), (String)unionId);
                identities.add(unionIdentity);
                break;
            }
            case WECHAT_OFFIACCOUNT: {
                WechatOffiaccountSNSUserToken offiaccountSNSToken = (WechatOffiaccountSNSUserToken)token;
                String unionId = offiaccountSNSToken.getUnionId();
                if (!Objects.nonNull(unionId)) break;
                String unionKey = app.lookupUnionKey(authenticationKey);
                Identity unionIdentity = Identity.valueOf((AuthenticationKey)AuthenticationKey.valueOf((IdentityType)IdentityType.WECHAT_UNION, (String)unionKey), (String)unionId);
                identities.add(unionIdentity);
            }
        }
        return identities;
    }

    public static List<Identity> identityOfUserAppKeySNSIdentity(UserApp app, AuthenticationKey authenticationKey, SNSToken token) {
        SNSType type = token.getType();
        ArrayList identities = Lists.newArrayList((Object[])new Identity[]{SNSIdentityUtils.identityOfAuthenticationKeyAndToken(authenticationKey, token)});
        switch (type) {
            case WECHAT_WEAPP: {
                WechatWeappSNSToken weappSNSToken = (WechatWeappSNSToken)token;
                String unionId = weappSNSToken.getUnionId();
                if (!Objects.nonNull(unionId)) break;
                String unionKey = app.lookupUnionKey(authenticationKey);
                Identity unionIdentity = Identity.valueOf((AuthenticationKey)AuthenticationKey.valueOf((IdentityType)IdentityType.WECHAT_UNION, (String)unionKey), (String)unionId);
                identities.add(unionIdentity);
                break;
            }
            case WECHAT_OFFIACCOUNT: {
                WechatOffiaccountSNSToken offiaccountSNSToken = (WechatOffiaccountSNSToken)token;
                String unionId = offiaccountSNSToken.getUnionId();
                if (!Objects.nonNull(unionId)) break;
                String unionKey = app.lookupUnionKey(authenticationKey);
                Identity unionIdentity = Identity.valueOf((AuthenticationKey)AuthenticationKey.valueOf((IdentityType)IdentityType.WECHAT_UNION, (String)unionKey), (String)unionId);
                identities.add(unionIdentity);
            }
        }
        return identities;
    }
}

