/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.config;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.beast.user.config.EntranceFeature;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.IdentityType;
import org.beast.user.core.LoginType;

public class AppEntrances {
    private Map<String, Config> entrances;

    public AppEntrances(Map<String, Config> entrances) {
        this.entrances = entrances;
    }

    public boolean support(String key) {
        return this.entrances.containsKey(key);
    }

    private Config getEntranceConfig(String entrance) {
        Config config = this.entrances.get(entrance);
        if (config == null) {
            throw new IllegalStateException("entrance: " + entrance + " entrance-config invalid ");
        }
        return config;
    }

    public boolean enableEntrance(String entrance) {
        return this.entrances.containsKey(entrance);
    }

    public AuthenticationKey lookup(String entrance, IdentityType type) {
        Config config = this.getEntranceConfig(entrance);
        for (AuthenticationKey authentication : config.getAuthentications()) {
            if (authentication.getIdentityType() != type) continue;
            return authentication;
        }
        throw new IllegalStateException("Unsupported entrance:'" + entrance + "' type: '" + type + "'");
    }

    public boolean enableAuthentication(String entrance, IdentityType type) {
        Config config = this.getEntranceConfig(entrance);
        for (AuthenticationKey authentication : config.authentications) {
            if (authentication.getIdentityType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean isEnable(String entrance, EntranceFeature feature) {
        Config config = this.getEntranceConfig(entrance);
        Map<String, Boolean> features = config.getFeatures();
        Boolean value = features.get(feature.name());
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }

    public List<LoginType> getLoginTypes(String entrance) {
        Config config = this.getEntranceConfig(entrance);
        return config.getLoginTypes();
    }

    public List<IdentityType> types(String entrance) {
        Config config = this.getEntranceConfig(entrance);
        return config.getAuthentications().stream().map(AuthenticationKey::getIdentityType).collect(Collectors.toList());
    }

    public static class Config {
        private List<LoginType> loginTypes;
        private Map<String, String> metadata = new HashMap<String, String>();
        private Map<String, Boolean> features = new HashMap<String, Boolean>();
        private List<AuthenticationKey> authentications = Lists.newArrayList();
        public boolean enable = true;

        public List<LoginType> getLoginTypes() {
            return this.loginTypes;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Map<String, Boolean> getFeatures() {
            return this.features;
        }

        public List<AuthenticationKey> getAuthentications() {
            return this.authentications;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setLoginTypes(List<LoginType> loginTypes) {
            this.loginTypes = loginTypes;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public void setFeatures(Map<String, Boolean> features) {
            this.features = features;
        }

        public void setAuthentications(List<AuthenticationKey> authentications) {
            this.authentications = authentications;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

