package org.beast.user.config;

/**
 * 身份认证配置
 */
public enum AuthenticationFeature {

    /**
     * 是否允许创建用户
     * 开启可禁止直接创建新用户
     */
    CREATE_USER(false),


    /**
     * 不存在则自动创建
     * 对比CreateUser 开启会自动创建用户，而不用指定force
     */
    AUTO_CREATE_USER(false),

    /**
     * 是否允许覆盖绑定
     * 开启允许覆盖绑定，关闭则限制不能直接覆盖需先解绑
     * 用户已绑定identifier，将覆盖
     */
    OVERWRITE_BIND(false),

    /**
     * 自动覆盖绑定
     * 开启后 会自动覆盖绑定
     */
    AUTO_OVERWRITE_BIND(false),

    /**
     * 拒绝认证
     * 开启可禁止认证
     */
    DENY(false),

    /**
     * 开启拒绝新认证
     * 已有的认证将会保留，新认证将拒绝访问
     */
    DENY_NEW(false),


    /**
     * 微信的unionId
     */
    WITH_UNION(false),


    ;
    private final boolean defaultState;

    AuthenticationFeature(boolean defaultState) {
        this.defaultState = defaultState;
    }

    public boolean enabledByDefault() {
        return defaultState;
    }
}
