/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.beast.user.config.AnonymousConfiguration;
import org.beast.user.config.AppAuthentication;
import org.beast.user.config.AppAuthentications;
import org.beast.user.config.AppEntrances;
import org.beast.user.config.AppProperties;
import org.beast.user.config.AppThirdpartyBinding;
import org.beast.user.config.AuthenticationFeature;
import org.beast.user.config.EntranceFeature;
import org.beast.user.core.Apped;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.IdentityType;
import org.beast.user.core.LoginType;
import org.beast.user.core.SNSType;
import org.beast.user.core.http.CookieControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class UserApp {
    private static final Logger log = LoggerFactory.getLogger(UserApp.class);
    private String id;
    private String name;
    private String logo;
    private Map<String, String> metadata;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private CookieControl cookieControl;
    private AppEntrances entrances;
    private AnonymousConfiguration anonymous;
    private AppAuthentications authentications;
    private List<AppThirdpartyBinding> thirdpartys = Lists.newArrayList();

    public UserApp(AppProperties properties) {
        this.id = properties.getId();
        this.name = properties.getName();
        this.logo = properties.getLogo();
        this.metadata = properties.getMetadata();
        this.features = properties.getFeatures();
        this.cookieControl = properties.getCookieControl();
        this.entrances = new AppEntrances(properties.getEntrances());
        this.authentications = new AppAuthentications(properties.getAuthentications().stream().collect(Collectors.toMap(AppAuthentication::getKey, item -> item)));
        this.anonymous = properties.getAnonymous();
        this.thirdpartys = properties.getThirdpartys();
    }

    public String id() {
        return this.id;
    }

    public boolean enableByEntrance(String entrance) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.enableEntrance(entrance);
    }

    public boolean enableByEntrance(String entrance, EntranceFeature feature) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.isEnable(entrance, feature);
    }

    public boolean enableByAuthenticateFeature(AuthenticationKey key, AuthenticationFeature feature) {
        return this.authentications.isEnable(key, feature);
    }

    public boolean enableByAuthenticateFeature(@Nullable String entrance, IdentityType type, AuthenticationFeature feature) {
        if (entrance == null) {
            entrance = this.id;
        }
        AuthenticationKey key = this.entrances.lookup(entrance, type);
        return this.enableByAuthenticateFeature(key, feature);
    }

    public boolean enableAuthenticationType(@Nullable String entrance, IdentityType identityType) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.enableAuthentication(entrance, identityType);
    }

    public AuthenticationKey authenticationKey(@Nullable String entrance, SNSType snsType) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.authenticationKey(entrance, snsType.toIdentityType());
    }

    public AuthenticationKey authenticationKey(@Nullable String entrance, IdentityType identityType) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.lookup(entrance, identityType);
    }

    public boolean contain(AuthenticationKey key) {
        return this.authentications.keys().contains(key);
    }

    public AppAuthentication get(AuthenticationKey key) {
        AppAuthentication authentication = this.authentications.get(key);
        if (authentication == null) {
            throw new IllegalStateException("authentication-key: " + key + " config unsupported, supports [{" + this.authentications.keys() + "}]");
        }
        return authentication;
    }

    public AppAuthentication get(SNSType type) {
        AuthenticationKey key = this.authenticationKey(this.id, type);
        return this.get(key);
    }

    public AppAuthentication get(String entrance, SNSType type) {
        AuthenticationKey key = this.authenticationKey(entrance, type);
        return this.get(key);
    }

    public String lookupSNSApp(@Nullable String entrance, SNSType type) {
        AuthenticationKey key = this.authenticationKey(entrance, type.toIdentityType());
        return this.lookupSNSApp(key);
    }

    public String lookupSNSApp(AuthenticationKey key) {
        AppAuthentication authentication = this.get(key);
        return authentication.getMetadataValue("app");
    }

    public List<LoginType> getLoginTypes(@Nullable String entrance) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.getLoginTypes(entrance);
    }

    public List<SNSType> getSNSTypes(@Nullable String entrance) {
        if (entrance == null) {
            entrance = this.id;
        }
        List<IdentityType> types = this.entrances.types(entrance);
        ArrayList output = Lists.newArrayList();
        for (IdentityType type : types) {
            try {
                output.add(SNSType.valueOfIdentityType((IdentityType)type));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return output;
    }

    public boolean own(Apped apped) {
        return this.id.equals(apped.appId());
    }

    public List<AppThirdpartyBinding> thirdpartys() {
        return this.thirdpartys;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public void setCookieControl(CookieControl cookieControl) {
        this.cookieControl = cookieControl;
    }

    public void setEntrances(AppEntrances entrances) {
        this.entrances = entrances;
    }

    public void setAnonymous(AnonymousConfiguration anonymous) {
        this.anonymous = anonymous;
    }

    public void setAuthentications(AppAuthentications authentications) {
        this.authentications = authentications;
    }

    public void setThirdpartys(List<AppThirdpartyBinding> thirdpartys) {
        this.thirdpartys = thirdpartys;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLogo() {
        return this.logo;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public CookieControl getCookieControl() {
        return this.cookieControl;
    }
}

