package org.beast.user.config;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import java.util.List;
import java.util.stream.Collectors;

@EnableConfigurationProperties(UserProperties.class)
@Configuration
public class UserAutoConfiguration {


    @Bean
    public AppRegistry appService(UserProperties userProperties, Environment environment) {
        List<AppProperties> propertiesList = userProperties.getApps();
        List<UserApp> apps = propertiesList.stream().map(UserApp::new).collect(Collectors.toList());
        return new AppRegistry(apps);
    }
}
