package org.beast.user.config;

import lombok.Getter;
import lombok.Setter;
import org.beast.user.core.AuthenticationKey;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 认证配置
 */
@Getter @Setter
public class AppAuthentications {

    /**
     * 是否要求必须绑定手机号 （允许解绑或覆盖）
     * 当第三方登录时将，会进入绑定手机页面 ， 且允许手机号创建用户
     */

    private Map<AuthenticationKey, AppAuthentication> authentications = new HashMap<>();

    public AppAuthentications(Map<AuthenticationKey, AppAuthentication> authentications) {
        this.authentications = authentications;
    }


    public Set<AuthenticationKey> keys() {
        return this.authentications.keySet();
    }


    public AppAuthentication get(AuthenticationKey key) {
        return this.authentications.get(key);
    }

    public boolean isEnable(AuthenticationKey key, AuthenticationFeature feature) {
        AppAuthentication authentication = this.get(key);
        return authentication.isEnable(feature);
    }

}
