package org.beast.user.config;

import lombok.Getter;
import lombok.Setter;
import org.beast.user.core.AuthenticationKey;

import java.util.HashMap;
import java.util.Map;

@Getter @Setter
public class AppAuthentication {

    private AuthenticationKey key;

    private Map<String, String> metadata = new HashMap<>();

    private Map<String, Boolean> features = new HashMap<>();

    private boolean enabled = true;


    public static final String METADATA_KEY_SNS_APP = "app";
    public static final String METADATA_KEY_PLATFORM_APP= "platformAppId";

    public String getMetadataValue(String key) {
        return this.metadata.get(key);
    }


    public boolean isEnable(AuthenticationFeature feature) {
        String featureKey = feature.name();
        Boolean value = features.get(featureKey);
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }
}
