package org.beast.user.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;


public class AppService {

    private Map<String, UserApp> apps = Maps.newHashMap();

    public AppService(List<UserApp> apps) {
        this.apps = apps.stream().collect(Collectors.toMap(UserApp::getId, app -> app));
    }

    public List<UserApp> findAll() {
        return Lists.newArrayList(this.apps.values());
    }

    public Optional<UserApp> getByApp(String appId) {
        return Optional.ofNullable(apps.get(appId));
    }
}
