package org.beast.user.config;

import com.google.common.collect.Lists;
import org.beast.user.core.http.CookieControl;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AppProperties {

    private String id;


    private String name;

    /**
     * LOGO 42x48
     */
    private String logo;


    private Map<String, String> metadata;

    private Map<String, Boolean> features = new HashMap<>();

    private CookieControl cookieControl;

    private Map<String, EntranceConfig.Config> entrances;

    private List<AuthenticationConfig.Config> authentications = Lists.newArrayList();
}
