/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.beast.user.config.AuthenticationFeature;
import org.beast.user.core.AuthenticationKey;

public class AuthenticationConfig {
    private Map<AuthenticationKey, Config> authentications = new HashMap<AuthenticationKey, Config>();

    public AuthenticationConfig(Map<AuthenticationKey, Config> authentications) {
        this.authentications = authentications;
    }

    public Set<AuthenticationKey> keys() {
        return this.authentications.keySet();
    }

    public Config getAuthenticationConfig(AuthenticationKey key) {
        Config config = this.authentications.get(key);
        return config;
    }

    public boolean isEnable(AuthenticationKey key, AuthenticationFeature feature) {
        Config config = this.getAuthenticationConfig(key);
        if (config == null) {
            return feature.enabledByDefault();
        }
        String featureKey = feature.name();
        Map<String, Boolean> features = config.getFeatures();
        Boolean value = features.get(featureKey);
        if (value == null) {
            return feature.enabledByDefault();
        }
        return value;
    }

    public Map<AuthenticationKey, Config> getAuthentications() {
        return this.authentications;
    }

    public void setAuthentications(Map<AuthenticationKey, Config> authentications) {
        this.authentications = authentications;
    }

    public static class Config {
        private AuthenticationKey key;
        private Map<String, String> metadata = new HashMap<String, String>();
        private Map<String, Boolean> features = new HashMap<String, Boolean>();
        private boolean enable = true;

        public AuthenticationKey getKey() {
            return this.key;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Map<String, Boolean> getFeatures() {
            return this.features;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setKey(AuthenticationKey key) {
            this.key = key;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public void setFeatures(Map<String, Boolean> features) {
            this.features = features;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

