/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beast.user.config.AppProperties;
import org.beast.user.config.AuthenticationConfig;
import org.beast.user.config.AuthenticationFeature;
import org.beast.user.config.AuthenticationKey;
import org.beast.user.config.EntranceConfig;
import org.beast.user.config.EntranceFeature;
import org.beast.user.core.IdentityType;
import org.beast.user.core.SNSType;
import org.beast.user.core.http.CookieControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private String id;
    private String name;
    private String logo;
    private Map<String, String> metadata;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private CookieControl cookieControl;
    private EntranceConfig entrances;
    private AuthenticationConfig authentications;

    public App(AppProperties properties) {
        this.id = properties.getId();
        this.name = properties.getName();
        this.logo = properties.getLogo();
        this.metadata = properties.getMetadata();
        this.features = properties.getFeatures();
        this.cookieControl = properties.getCookieControl();
        this.entrances = new EntranceConfig(properties.getEntrances());
        this.authentications = new AuthenticationConfig(properties.getAuthentications());
    }

    public boolean enableByEntrance(String entrance) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.enableEntrance(entrance);
    }

    public boolean enableByEntrance(String entrance, EntranceFeature feature) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.isEnable(entrance, feature);
    }

    public boolean enableByAuthenticateFeature(AuthenticationKey key, AuthenticationFeature feature) {
        return this.authentications.isEnable(key, feature);
    }

    public boolean enableByAuthenticateFeature(String entrance, IdentityType type, AuthenticationFeature feature) {
        if (entrance == null) {
            entrance = this.id;
        }
        AuthenticationKey key = this.entrances.lookup(entrance, type);
        return this.enableByAuthenticateFeature(key, feature);
    }

    public boolean enableAuthenticationType(String entrance, IdentityType identityType) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.enableAuthentication(entrance, identityType);
    }

    public AuthenticationKey authenticationKey(String entrance, IdentityType identityType) {
        if (entrance == null) {
            entrance = this.id;
        }
        return this.entrances.lookup(entrance, identityType);
    }

    public String lookupSNSApp(@Nullable String entrance, SNSType type) {
        IdentityType identityType;
        AuthenticationKey key;
        AuthenticationConfig.Config config;
        if (entrance == null) {
            entrance = this.id;
        }
        if ((config = this.authentications.getAuthenticationConfig(key = this.entrances.lookup(entrance, identityType = type.toIdentityType()))) == null) {
            throw new IllegalStateException("authentication key: " + key + " config unsupported, supports [{" + this.authentications.keys() + "}]");
        }
        Map<String, String> metadata = config.getMetadata();
        return metadata.get("app");
    }

    public List<SNSType> getSNSTypes(@Nullable String entrance) {
        if (entrance == null) {
            entrance = this.id;
        }
        List<IdentityType> types = this.entrances.types(entrance);
        ArrayList output = Lists.newArrayList();
        for (IdentityType type : types) {
            try {
                output.add(SNSType.valueOf((IdentityType)type));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return output;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public void setCookieControl(CookieControl cookieControl) {
        this.cookieControl = cookieControl;
    }

    public void setEntrances(EntranceConfig entrances) {
        this.entrances = entrances;
    }

    public void setAuthentications(AuthenticationConfig authentications) {
        this.authentications = authentications;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLogo() {
        return this.logo;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public CookieControl getCookieControl() {
        return this.cookieControl;
    }
}

