package org.beast.user.web;

import org.beast.data.message.MessageErrorOwner;
import org.beast.user.MessageErrors;
import org.beast.web.bind.MessageErrorOwnerProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
public class UserAppAutoConfiguration {



    @Bean
    public MessageErrorOwnerProvider applicationErrorOwnerProvider() {
        return new MessageErrorOwnerProvider() {
            public MessageErrorOwner ofCode(String code) throws Throwable {
                return MessageErrors.valueOf(code);
            }
        };
    }



}
