package org.beast.user.transformer;



import org.beast.data.util.EmailUtils;
import org.beast.data.util.MobileUtils;
import org.beast.user.core.IdentityType;
import org.beast.user.data.SecuredUserIdentity;
import org.beast.user.data.UserIdentity;

import java.util.function.Function;

public class UserIdentityToSecured implements Function<UserIdentity, SecuredUserIdentity> {
    @Override
    public SecuredUserIdentity apply(UserIdentity identity) {

        IdentityType type = identity.getIdentityType();

        var identifier = identity.getIdentifier();
        var securityIdentifier = switch (type) {
            case MOBILE -> MobileUtils.cover(identifier);
            case EMAIL -> EmailUtils.cover(identifier);
            case WECHAT_OFFIACCOUNT -> identifier;
            default -> identifier;
        };
        return SecuredUserIdentity.builder()
                .identityType(identity.getIdentityType())
                .group(identity.getGroup())
                .createdAt(identity.getCreatedAt())
                .identifier(securityIdentifier)
                .build();
    }
}
