package org.beast.user;

import org.beast.data.message.MessageErrorOwner;

public enum MessageErrors implements MessageErrorOwner {
    USR_ERR_DENIED(),                //操作过于频繁
    USR_ERR_DENIED_1M(),           //操作过于频繁，请1 分钟后重试
    USR_ERR_DENIED_4H(),             //操作过于频繁，请4 小时后重试


    USR_ERR_ANONYMOUS_TICKET_REQUIRED(),


    USR_ERR_APP_MISSING(),            //APP 不存在


    USR_ERR_IDENTITY_MISSING(),

    USR_ERR_IDENTIFIER_INVALID,
    //绑定时，标识已被绑定
    USR_ERR_IDENTIFIER_REPEAT,
    //拒绝认证
    USR_ERR_AUTHENTICATE_DENY,
    //认证需要进行绑定登录
    USR_ERR_REQUIRED_BIND,
    //认证需要进行手机绑定
    USR_ERR_REQUIRED_BIND_MOBILE,

    USR_ERR_PASSWORD_WRONG(),     //账号或密码错误，请重新输入，建议使用手机号短信验证码登录
    USR_ERR_PASSWORD_INVALID,     //密码格式错误
    USR_ERR_PASSWORD_UNINITIALIZED,
    //该用户，身份已存在（客户端处理异常， 允许提交force来覆盖绑定）
    USR_ERR_USER_IDENTITY_EXISTS,
    //同 USR_ERR_USER_IDENTITY_EXISTS 这个是处理withToken的
    USR_ERR_WITH_TOKEN_IDENTITY_EXISTS(),


    //该用户，身份已绑定 （不允许覆盖，客户端进行提示 要求解绑再重新绑定）
    USR_ERR_USER_IDENTITY_ALREADY_BIND,
    //同 UUSR_ERR_USER_IDENTITY_ALREADY_BIND 这个是处理withToken的
    USR_ERR_WITH_TOKEN_IDENTITY_ALREADY_BIND(),


    USR_ERR_MOBILE_ALREADY_SIGNUP,
    USR_ERR_EMAIL_ALREADY_SIGNUP,
    USR_ERR_USERNAME_ALREADY_SIGNUP,
    USR_ERR_WECHAT_ALREADY_SIGNUP,
    //用户不存在, (允许创建)
    USR_ERR_USER_MISSING,
    USR_ERR_USER_STATE_ABNORMAL,
    //用户必须绑定手机号
    USR_ERR_USER_REQUIRED_BIND_MOBILE,

    USR_ERR_USER_INVALID, //用户无效

    //无效的SNSUserToken
    USR_ERR_SNS_USER_TOKEN_INVALID(),
    USR_ERR_WECHAT_USER_TOKEN_INVALID(), //无效的WechatUserToken
    USR_ERR_MOBILE_CODE_WRONG,    //手机安全码错误


    USR_ERR_VERIFY_TOKEN_ERROR,   //认证凭证错误
    USR_ERR_IV_TOKEN_WRONG,

    USR_ERR_CERTIFY_WRONG,    //证明错误


    //

    USR_ERR_ENTRANCE_INVALID(),

    USR_ERR_CAPTCHA_REQUIRED(),   //请输入验证码 (触发限制)
    USR_ERR_CAPTCHA_WRONG(),      //验证码错误
    USR_ERR_MOBILE_INVALID(),     //手机号码无效

    USR_ERR_LOGIN_ID_INVALID(),      //loginId 无效
    USR_ERR_USERNAME_INVALID(),      //用户名 无效

    USR_ERR_TOKEN_EXPIRE(),        //登录凭证 过期
    USR_ERR_LOGINTOKEN_TYPE_INVALID(),   //登录 令牌类型无效
    USR_ERR_AUTHORIZATION_INVALID(),    //无效授权码
    USR_ERR_AUTHORIZATION_UNBIND(),    //授权未绑定用户
    USR_ERR_PASSWORD_REQUIRED(),      //请输入密码


    USR_ERR_WITH_TOKEN_INVALIDED(),




    USR_ERR_FLOW_EXPIRED(),

    USR_ERR_IDENTITY_CARD_INVALID(), //用户身份证无效


    //已过期
//    USR_ERR_FLOW_EXPIRED(),

    IV_ERR_VERIFY_EXPIRE(),

    //身份认证错误
    IV_ERR_TOKEN_EXPIRE(),


    IV_ERR_VERIFY_TOKEN_WRONG(),
    ;

    private String errorCode;

    MessageErrors() {
        this.errorCode = this.name();
    }

    public static MessageErrorOwner valueOfMessage(String message) {
        return MessageErrors.valueOf(message);
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }
}
