package org.beast.user.client.dto;

import lombok.Getter;
import lombok.Setter;
import org.springframework.lang.Nullable;

/**
 * 身份token
 *
 * - userToken
 * - ivToken
 */
@Getter
@Setter
public class IdentityTokenInput {

    @Nullable
    private String userToken;

    @Nullable
    private String ivToken;


    /**
     * 是否强制, 将会删除现有标识绑定，且覆盖用户标识
     */
    private Boolean force;

    /**
     * 是否可覆盖，将会覆盖用户标识
     */
    private Boolean overwrite;

}
