package org.beast.user.client;

import org.beast.data.message.ReturnResult;
import org.beast.user.client.dto.SNSAuthorizeUriCreateInput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient("beast-user-webpassport")
public interface UserWebClient {

    @PostMapping("/app/api/sns/authorize-uri")
    ReturnResult<String> authorizeUri(
            @RequestHeader("X-App") String app,
            @RequestBody SNSAuthorizeUriCreateInput input
    );


}
