package org.beast.user.client;


import com.fasterxml.jackson.databind.node.ObjectNode;
import org.beast.data.message.ReturnResult;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.data.*;
import org.beast.user.client.dto.*;
import org.beast.user.data.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.List;

@FeignClient("beast-user-center")
public interface UserCenterClient {

    @PostMapping("/app/api/password-login")
    ReturnResult<AppUserLoginOutput> passwordLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppPasswordLoginInput input
    );

    @PostMapping("/app/api/mobile-login")
    ReturnResult<AppUserLoginOutput> mobileLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppMobileLoginInput input
    );

    @PostMapping("/app/api/sns-login")
    ReturnResult<AppUserLoginOutput> snsLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppSNSLoginInput input
    );

    @PostMapping("/app/api/anonymous-login")
    ReturnResult<AppUserLoginOutput> anonymousLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppAnonymousLoginInput input
    );

    @PostMapping("/app/api/jump-login")
    ReturnResult<AppUserLoginOutput> jumpLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppJumpLoginInput input
    );

    @PostMapping("/app/api/mobile-signup")
    ReturnResult<?> mobileSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody MobileSignUpInput input
    );

    @PostMapping("/app/api/email-signup")
    ReturnResult<?> emailSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody EmailSignUpInput input
    );

    @PostMapping("/app/api/username-signup")
    ReturnResult<?> usernameSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody UsernameSignUpInput input
    );


    @PostMapping("/app/api/mobile/send-code")
    ReturnResult<?> sendMobileCode(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppSendMobileCodeInput input
    );

    @PostMapping("/app/api/mobile/verify-code")
    ReturnResult<AppMobileCodeVerifyOutput> verifyMobileCode(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppMobileCodeVerifyInput input
    );


    @PostMapping("/app/api/sns-user-token/verify")
    ReturnResult<AppSNSUserTokenVerifyOutput> verifySNSUserToken(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppSNSUserTokenVerifyInput input
    );

//    @PostMapping("/app/api/wechat-user-token/verify")
//    ReturnResult<AppWechatUserTokenVerifyOutput> verifyWechatUserToken(
//            @RequestHeader(name = "X-App") String appId,
//            @RequestBody AppWechatUserTokenVerifyInput input
//    );



    @GetMapping("/app/api/user")
    ReturnResult<User> findUserByIdentifier(
            @RequestHeader(name = "X-App") String appId,
            @RequestParam(name = "key") AuthenticationKey key,
            @RequestParam("identifier") String identifier
    );

    @PostMapping("/app/api/user-password/verify")
    ReturnResult<AppUserPasswordVerifyOutput> verifyUserPwd(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppUserPasswordVerifyInput input
    );

    @GetMapping("/app/api/users/{uid}/identitys/{key}")
    ReturnResult<UserIdentity> findIdentityByUidAndKey(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @PathVariable("key") AuthenticationKey key
    );
    @PostMapping("/app/api/users/{uid}/identitys/{key}/connect-sns")
    ReturnResult<List<UserIdentity>> connectIdentitySNSByUidAndKey(
            @RequestHeader(name = "X-App") String appid,
            @PathVariable("uid") long uid,
            @PathVariable("key") AuthenticationKey key,
            @RequestBody UserIdentityConnectSNSInput input
    );

    @GetMapping("/app/api/users/{uid}/identitys")
    ReturnResult<List<UserIdentity>> findIdentitysByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @GetMapping("/app/api/users/{uid}/secured-identitys")
    ReturnResult<List<SecuredUserIdentity>> findSecuredIdentitysByUID(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @GetMapping("/app/api/users/{uid}/secured-identitys/{key}")
    ReturnResult<SecuredUserIdentity> findSecuredIdentitysByUID(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @PathVariable("key") AuthenticationKey key
    );

    @GetMapping("/app/api/users")
    ReturnResult<List<User>> findUsersByIdIn(
            @RequestHeader(name = "X-App") String appId,
            @RequestParam("id") Collection<Long> ids
    );

    @GetMapping("/app/api/users/{uid}")
    ReturnResult<User> findUserById(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );



    @GetMapping("/app/api/users/{uid}/info")
    ReturnResult<Userinfo> findUserinfoByUID(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @PostMapping("/app/api/users/{uid}/authorization")
    ReturnResult<UserAuthorization> createUserAuthorization(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @PutMapping("/app/api/users/{uid}")
    ReturnResult<UserBasicInfo> saveUserInfoByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @RequestBody UserBasicInfo input
    );

    @PatchMapping("/app/api/users/{uid}")
    ReturnResult<UserBasicInfo> patchUserBy(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @RequestBody ObjectNode input
    );

    @GetMapping("/app/api/users/{uid}/basic")
    ReturnResult<UserBasicInfo> patchUserBasicById(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );
    @GetMapping("/app/api/users/{uid}/basic")
    ReturnResult<UserBasicInfo> findUserBasicById(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );


    @GetMapping("/app/api/users/{uid}/identity-card")
    ReturnResult<IdentityCard> getIdentityCardByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long userId
    );


    @PostMapping("/app/api/iv/identity-verify")
    ReturnResult<IVVerifyOutput> createIdentityVerify(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody IdentityVerifyCreateInput input
    );


    @PostMapping("/app/api/account/password")
    ReturnResult<?> setPassword(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SetPasswordInput input
    );

    @PostMapping("/app/api/account/mobile")
    ReturnResult<?> setMobile(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody BindMobileInput input
    );

    @PostMapping("/app/api/account/email")
    ReturnResult<?> setEmail(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody BindEmailInput input
    );

    @PostMapping("/app/api/users/{userId}/certify")
    ReturnResult<?> createCertify(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable(name = "userId") long userId,
            @RequestBody CreateCertifyInput input
    );

    @PostMapping("/app/api/account/sns/{key}")
    ReturnResult<?> binsSNS(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable(name = "key") AuthenticationKey key,
            @RequestBody SNSTokenWithIdentityTokenInput input
    );

    @DeleteMapping("/app/api/account/sns/{key}")
    ReturnResult<?> unbindSNS(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable(name = "key") AuthenticationKey key,
            @RequestBody IdentityTokenInput input
    );

}
