/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import org.beast.data.message.ReturnResult;
import org.beast.user.client.dto.BindEmailInput;
import org.beast.user.client.dto.BindMobileInput;
import org.beast.user.client.dto.CreateCertifyInput;
import org.beast.user.client.dto.EmailSignUpInput;
import org.beast.user.client.dto.IVVerifyOutput;
import org.beast.user.client.dto.IdentityTokenInput;
import org.beast.user.client.dto.IdentityVerifyCreateInput;
import org.beast.user.client.dto.MobileSignUpInput;
import org.beast.user.client.dto.SNSTokenWithIdentityTokenInput;
import org.beast.user.client.dto.SetPasswordInput;
import org.beast.user.client.dto.UsernameSignUpInput;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.data.IdentityCard;
import org.beast.user.data.SecuredUserIdentity;
import org.beast.user.data.User;
import org.beast.user.data.UserBasicInfo;
import org.beast.user.data.UserIdentity;
import org.beast.user.data.Userinfo;
import org.beast.user.data.dto.AppAnonymousLoginInput;
import org.beast.user.data.dto.AppJumpLoginInput;
import org.beast.user.data.dto.AppMobileCodeVerifyInput;
import org.beast.user.data.dto.AppMobileCodeVerifyOutput;
import org.beast.user.data.dto.AppMobileLoginInput;
import org.beast.user.data.dto.AppPasswordLoginInput;
import org.beast.user.data.dto.AppSNSLoginInput;
import org.beast.user.data.dto.AppSNSUserTokenVerifyInput;
import org.beast.user.data.dto.AppSNSUserTokenVerifyOutput;
import org.beast.user.data.dto.AppSendMobileCodeInput;
import org.beast.user.data.dto.AppUserLoginOutput;
import org.beast.user.data.dto.AppUserPasswordVerifyInput;
import org.beast.user.data.dto.AppUserPasswordVerifyOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="beast-user-center")
public interface UserCenterClient {
    @PostMapping(value={"/app/api/password-login"})
    public ReturnResult<AppUserLoginOutput> passwordLogin(@RequestHeader(name="X-App") String var1, @RequestBody AppPasswordLoginInput var2);

    @PostMapping(value={"/app/api/mobile-login"})
    public ReturnResult<AppUserLoginOutput> mobileLogin(@RequestHeader(name="X-App") String var1, @RequestBody AppMobileLoginInput var2);

    @PostMapping(value={"/app/api/sns-login"})
    public ReturnResult<AppUserLoginOutput> snsLogin(@RequestHeader(name="X-App") String var1, @RequestBody AppSNSLoginInput var2);

    @PostMapping(value={"/app/api/anonymous-login"})
    public ReturnResult<AppUserLoginOutput> anonymousLogin(@RequestHeader(name="X-App") String var1, @RequestBody AppAnonymousLoginInput var2);

    @PostMapping(value={"/app/api/jump-login"})
    public ReturnResult<AppUserLoginOutput> jumpLogin(@RequestHeader(name="X-App") String var1, @RequestBody AppJumpLoginInput var2);

    @PostMapping(value={"/app/api/mobile-signup"})
    public ReturnResult<?> mobileSignUp(@RequestHeader(name="X-App") String var1, @RequestBody MobileSignUpInput var2);

    @PostMapping(value={"/app/api/email-signup"})
    public ReturnResult<?> emailSignUp(@RequestHeader(name="X-App") String var1, @RequestBody EmailSignUpInput var2);

    @PostMapping(value={"/app/api/username-signup"})
    public ReturnResult<?> usernameSignUp(@RequestHeader(name="X-App") String var1, @RequestBody UsernameSignUpInput var2);

    @PostMapping(value={"/app/api/mobile/send-code"})
    public ReturnResult<?> sendMobileCode(@RequestHeader(name="X-App") String var1, @RequestBody AppSendMobileCodeInput var2);

    @PostMapping(value={"/app/api/mobile/verify-code"})
    public ReturnResult<AppMobileCodeVerifyOutput> verifyMobileCode(@RequestHeader(name="X-App") String var1, @RequestBody AppMobileCodeVerifyInput var2);

    @PostMapping(value={"/app/api/sns-user-token/verify"})
    public ReturnResult<AppSNSUserTokenVerifyOutput> verifySNSUserToken(@RequestHeader(name="X-App") String var1, @RequestBody AppSNSUserTokenVerifyInput var2);

    @GetMapping(value={"/app/api/user"})
    public ReturnResult<User> findUserByIdentifier(@RequestHeader(name="X-App") String var1, @RequestParam(name="key") AuthenticationKey var2, @RequestParam(value="identifier") String var3);

    @PostMapping(value={"/app/api/user-password/verify"})
    public ReturnResult<AppUserPasswordVerifyOutput> verifyUserPwd(@RequestHeader(name="X-App") String var1, @RequestBody AppUserPasswordVerifyInput var2);

    @GetMapping(value={"/app/api/users/{uid}/identitys/{key}"})
    public ReturnResult<UserIdentity> findIdentityByUidAndKey(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2, @PathVariable(value="key") AuthenticationKey var4);

    @GetMapping(value={"/app/api/users/{uid}/identitys"})
    public ReturnResult<List<UserIdentity>> findIdentitysByUid(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @GetMapping(value={"/app/api/users/{uid}/secured-identitys"})
    public ReturnResult<List<SecuredUserIdentity>> findSecuredIdentitysByUID(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @GetMapping(value={"/app/api/users/{uid}/secured-identitys/{key}"})
    public ReturnResult<SecuredUserIdentity> findSecuredIdentitysByUID(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2, @PathVariable(value="key") AuthenticationKey var4);

    @GetMapping(value={"/app/api/users"})
    public ReturnResult<List<User>> findUsersByIds(@RequestHeader(name="X-App") String var1, @RequestParam(value="id") Collection<Long> var2);

    @GetMapping(value={"/app/api/users/{uid}/info"})
    public ReturnResult<Userinfo> findUserinfoByUID(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @PutMapping(value={"/app/api/users/{uid}"})
    public ReturnResult<UserBasicInfo> saveUserInfoByUid(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2, @RequestBody UserBasicInfo var4);

    @PatchMapping(value={"/app/api/users/{uid}"})
    public ReturnResult<UserBasicInfo> patchUserBy(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2, @RequestBody ObjectNode var4);

    @GetMapping(value={"/app/api/users/{uid}/basic"})
    public ReturnResult<UserBasicInfo> patchUserBasicById(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @GetMapping(value={"/app/api/users/{uid}/basic"})
    public ReturnResult<UserBasicInfo> findUserBasicById(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @GetMapping(value={"/app/api/users/{uid}/identity-card"})
    public ReturnResult<IdentityCard> getIdentityCardByUid(@RequestHeader(name="X-App") String var1, @PathVariable(value="uid") long var2);

    @PostMapping(value={"/app/api/iv/identity-verify"})
    public ReturnResult<IVVerifyOutput> createIdentityVerify(@RequestHeader(name="X-App") String var1, @RequestBody IdentityVerifyCreateInput var2);

    @PostMapping(value={"/app/api/account/password"})
    public ReturnResult<?> setPassword(@RequestHeader(name="X-App") String var1, @RequestBody SetPasswordInput var2);

    @PostMapping(value={"/app/api/account/mobile"})
    public ReturnResult<?> setMobile(@RequestHeader(name="X-App") String var1, @RequestBody BindMobileInput var2);

    @PostMapping(value={"/app/api/account/email"})
    public ReturnResult<?> setEmail(@RequestHeader(name="X-App") String var1, @RequestBody BindEmailInput var2);

    @PostMapping(value={"/app/api/users/{userId}/certify"})
    public ReturnResult<?> createCertify(@RequestHeader(name="X-App") String var1, @PathVariable(name="userId") long var2, @RequestBody CreateCertifyInput var4);

    @PostMapping(value={"/app/api/account/sns/{key}"})
    public ReturnResult<?> binsSNS(@RequestHeader(name="X-App") String var1, @PathVariable AuthenticationKey var2, @RequestBody SNSTokenWithIdentityTokenInput var3);

    @DeleteMapping(value={"/app/api/account/sns/{key}"})
    public ReturnResult<?> unbindSNS(@RequestHeader(name="X-App") String var1, @PathVariable AuthenticationKey var2, @RequestBody IdentityTokenInput var3);
}

