package org.beast.user.client.dto;

import org.beast.user.core.LoginWithTokenType;
import lombok.Getter;
import lombok.Setter;

@Getter @Setter
public class AbstractLoginInput {



    /**
     * 入口
     * 如： 微信公众号，游戏XXX，官网，推广渠道，根据不同入口相应配置
     */
    private String entrance;

    /**
     * 强制登陆，不存在是否直接创建用户
     */
    private Boolean force;

    /**
     * 指纹
     */
    private String fingerprint;

    /**
     * 登录-携带令牌
     */
    private LoginWithTokenType withTokenType;

    /**
     * 携带令牌
     */
    private String withToken;

    /**
     * 携带令牌-覆盖
     */
    private Boolean withTokenOverwrite;



}
