package org.beast.user.client;


import com.fasterxml.jackson.databind.node.ObjectNode;
import org.beast.data.message.ReturnResult;
import org.beast.user.core.AuthenticationKey;
import org.beast.user.core.IdentityType;
import org.beast.user.data.IdentityCard;
import org.beast.user.data.UserBasicInfo;
import org.beast.user.client.dto.*;
import org.beast.user.data.UserIdentity;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("beast-user-center")
public interface UserCenterClient {

    @PostMapping("/app/api/pwd-login")
    ReturnResult<LoginOutput> pwdLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody PwdLoginInput input
    );

    @PostMapping("/app/api/mobile-login")
    ReturnResult<LoginOutput> mobileLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody MobileLoginInput input
    );

    @PostMapping("/app/api/sns-login")
    ReturnResult<LoginOutput> snsLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SNSLoginInput input
    );

    @PostMapping("/app/api/anonymous-login")
    ReturnResult<LoginOutput> anonymousLogin(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AnonymousLoginInput input
    );
    @PostMapping("/app/api/mobile-signup")
    ReturnResult<?> mobileSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody MobileSignUpInput input
    );

    @PostMapping("/app/api/email-signup")
    ReturnResult<?> emailSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody EmailSignUpInput input
    );

    @PostMapping("/app/api/username-signup")
    ReturnResult<?> usernameSignUp(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody UsernameSignUpInput input
    );


    @PostMapping("/app/api/send-mobile-code")
    ReturnResult<?> sendMobileCode(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SendMobileCodeInput input
    );

    @PostMapping("/app/api/verify-mobile-code")
    ReturnResult<VerifyMobileCodeOutput> verifyMobileCode(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody VerifyMobileCodeInput input
    );


    @PostMapping("/app/api/wechat-user-token/verify")
    ReturnResult<?> verify(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody AppWechatUserTokenVerifyInput input
    );

    @Deprecated
    @GetMapping("/app/api/getUserIdByIdentity")
    ReturnResult<GetUserIdByIdentityOutput> getUserIdByIdentity(
            @RequestHeader(name = "X-App") String appId,
            @RequestParam("identityType") IdentityType identityType,
            @RequestParam("identifier") String identifier
    );

    @GetMapping("/app/api/user")
    ReturnResult<UserOutput> findUserByIdentifier(
            @RequestHeader(name = "X-App") String appId,
            @RequestParam(name = "key") AuthenticationKey key,
            @RequestParam("identifier") String identifier
    );

    @PostMapping("/app/api/verifyUserPwd")
    ReturnResult<?> verifyUserPwd(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody VerifyUserPwdInput input
    );

    @GetMapping("/app/api/users/{uid}/identitys/{key}")
    ReturnResult<UserIdentity> findIdentityByUidAndKey(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @PathVariable("key") AuthenticationKey key
    );

    @GetMapping("/app/api/users/{uid}/identitys")
    ReturnResult<List<UserIdentity>> findIdentitysByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @GetMapping("/app/api/users")
    ReturnResult<List<UserOutput>> findUsersBy(
            @RequestHeader(name = "X-App") String appId,
            @RequestParam("ids") List<Long> ids
    );


    @GetMapping("/app/api/users/{uid}")
    ReturnResult<UserOutput> getUserBy(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );

    @PutMapping("/app/api/users/{uid}")
    ReturnResult<UserBasicInfo> saveUserInfoByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @RequestBody UserBasicInfo input
    );

    @PatchMapping("/app/api/users/{uid}")
    ReturnResult<UserBasicInfo> patchUserBy(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid,
            @RequestBody ObjectNode input
    );

    @GetMapping("/app/api/users/{uid}/basic")
    ReturnResult<UserBasicInfo> patchUserBasicById(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );
    @GetMapping("/app/api/users/{uid}/basic")
    ReturnResult<UserBasicInfo> findUserBasicById(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long uid
    );


    @GetMapping("/app/api/users/{uid}/identity-card")
    ReturnResult<IdentityCard> getIdentityCardByUid(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable("uid") long userId
    );


    @PostMapping("/app/api/iv/identity-verify")
    ReturnResult<IVVerifyOutput> createIdentityVerify(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody IdentityVerifyCreateInput input
    );


    @PostMapping("/app/api/account/password")
    ReturnResult<?> setPassword(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SetPasswordInput input
    );

    @PostMapping("/app/api/account/mobile")
    ReturnResult<?> setMobile(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody BindMobileInput input
    );

    @PostMapping("/app/api/account/email")
    ReturnResult<?> setEmail(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody BindEmailInput input
    );

    @PostMapping("/app/api/users/{userId}/certify")
    ReturnResult<?> createCertify(
            @RequestHeader(name = "X-App") String appId,
            @PathVariable(name = "userId") long userId,
            @RequestBody CreateCertifyInput input
    );

    @PostMapping("/app/api/account/sns-bind")
    ReturnResult<?> snsBind(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SNSBindInput input
    );

    @PostMapping("/app/api/account/sns-unbind")
    ReturnResult<?> snsUnbind(
            @RequestHeader(name = "X-App") String appId,
            @RequestBody SNSUnbindInput input
    );

}
