package org.beast.user.client;

import org.beast.data.message.ReturnResult;
import org.beast.user.client.dto.SNSAuthorizeUriCreateInput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient("beast-user-webpassport")
public interface UserWebClient {

    @PostMapping("/apps/{app}/sns/authorize-uri")
    ReturnResult<String> authorizeUri(
            @PathVariable("app") String app,
            @RequestBody SNSAuthorizeUriCreateInput input
    );


}
