package org.beast.user.client;


import org.beast.data.message.ReturnResult;
import org.beast.user.core.IdentityType;
import org.beast.user.user.data.IdentityCard;
import org.beast.user.user.data.UserBasicInfo;
import org.beast.user.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("beast-user-center")
public interface UserCenterClient {

    @PostMapping("/apps/{app}/pwd-login")
    ReturnResult<LoginOutput> pwdLogin(
            @PathVariable(name = "app") String app,
            @RequestBody PwdLoginInput input
    );

    @PostMapping("/apps/{app}/mobile-login")
    ReturnResult<LoginOutput> mobileLogin(
            @PathVariable(name = "app") String app,
            @RequestBody MobileLoginInput input
    );

    @PostMapping("/apps/{app}/sns-login")
    ReturnResult<LoginOutput> snsLogin(
            @PathVariable(name = "app") String app,
            @RequestBody SNSLoginInput input
    );

    @PostMapping("/apps/{app}/mobile-signup")
    ReturnResult<?> mobileSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody MobileSignUpInput input
    );

    @PostMapping("/apps/{app}/email-signup")
    ReturnResult<?> emailSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody EmailSignUpInput input
    );

    @PostMapping("/apps/{app}/username-signup")
    ReturnResult<?> usernameSignUp(
            @PathVariable(name = "app") String app,
            @RequestBody UsernameSignUpInput input
    );


    @PostMapping("/apps/{app}/send-mobile-code")
    ReturnResult<?> sendMobileCode(
            @PathVariable(name = "app") String app,
            @RequestBody SendMobileCodeInput input
    );

    @PostMapping("/apps/{app}/verify-mobile-code")
    ReturnResult<VerifyMobileCodeOutput> verifyMobileCode(
            @PathVariable(name = "app") String app,
            @RequestBody VerifyMobileCodeInput input
    );


    @PostMapping("/apps/{app}/wechat-user-token/verify")
    ReturnResult<?> verify(
            @PathVariable(name = "app") String app,
            @RequestBody AppWechatUserTokenVerifyInput input
    );

    @GetMapping("/apps/{app}/getUserIdByIdentity")
    ReturnResult<GetUserIdByIdentityOutput> getUserIdByIdentity(
            @PathVariable(name = "app") String app,
            @RequestParam("identityType") IdentityType identityType,
            @RequestParam("identifier") String identifier
    );

    @PostMapping("/apps/{app}/verifyUserPwd")
    ReturnResult<?> verifyUserPwd(
            @PathVariable(name = "app") String app,
            @RequestBody VerifyUserPwdInput input
    );

    @GetMapping("/apps/{app}/getIdentityByUid")
    ReturnResult<UserIdentityOutput> getIdentityByUid(
            @PathVariable(name = "app") String app,
            @RequestParam("uid") long uid,
            @RequestParam("identityType") IdentityType identityType
    );

    @GetMapping("/apps/{app}/getIdentitiesByUid")
    ReturnResult<List<UserIdentityOutput>> getIdentitiesByUid(
            @PathVariable(name = "app") String app,
            @RequestParam("uid") long uid,
            @RequestParam("identityTypes") List<IdentityType> identityTypes
    );


    @GetMapping("/apps/{app}/users/{uid}")
    ReturnResult<UserOutput> getUserBy(
            @PathVariable(name = "app") String app,
            @PathVariable("uid") long uid
    );

    @PutMapping("/apps/{app}/users/{uid}")
    ReturnResult<?> updateUserBy(
            @PathVariable(name = "app") String app,
            @PathVariable("uid") long uid,
            @RequestBody UserInput input
    );

    @PatchMapping("/apps/{app}/users/{uid}")
    ReturnResult<?> patchUserBy(
            @PathVariable(name = "app") String app,
            @PathVariable("uid") long uid,
            @RequestBody UserInput input
    );

    @GetMapping("/apps/{app}/users/{uid}/basic-info")
    ReturnResult<UserBasicInfo> getBasicInfoBy(
            @PathVariable(name = "app") String app,
            @PathVariable("uid") long uid
    );


    @GetMapping("/apps/{app}/users/{uid}/identity-card")
    ReturnResult<IdentityCard> getIdentityCardByUid(
            @PathVariable(name = "app") String app,
            @PathVariable("uid") long userId
    );


    @PostMapping("/apps/{app}/iv/identity-verify")
    ReturnResult<IVVerifyOutput> createIdentityVerify(
            @PathVariable(name = "app") String app,
            @RequestBody IdentityVerifyCreateInput input
    );


    @PostMapping("/apps/{app}/account/password")
    ReturnResult<?> setPassword(
            @PathVariable(name = "app") String app,
            @RequestBody SetPasswordInput input
    );

    @PostMapping("/apps/{app}/account/mobile")
    ReturnResult<?> setMobile(
            @PathVariable(name = "app") String app,
            @RequestBody BindMobileInput input
    );

    @PostMapping("/apps/{app}/account/email")
    ReturnResult<?> setEmail(
            @PathVariable(name = "app") String app,
            @RequestBody BindEmailInput input
    );

    @PostMapping("/apps/{app}/users/{userId}/certify")
    ReturnResult<?> createCertify(
            @PathVariable(name = "app") String app,
            @PathVariable(name = "userId") long userId,
            @RequestBody CreateCertifyInput input
    );

    @PostMapping("/apps/{app}/account/sns-bind")
    ReturnResult<?> snsBind(
            @PathVariable(name = "app") String app,
            @RequestBody SNSBindInput input
    );

    @PostMapping("/apps/{app}/account/sns-unbind")
    ReturnResult<?> snsUnbind(
            @PathVariable(name = "app") String app,
            @RequestBody SNSUnbindInput input
    );

}
