/*
 * Decompiled with CFR 0.152.
 */
package org.beast.user.client;

import java.util.List;
import org.beast.data.message.ReturnResult;
import org.beast.user.client.dto.AppWechatUserTokenVerifyInput;
import org.beast.user.client.dto.BindEmailInput;
import org.beast.user.client.dto.BindMobileInput;
import org.beast.user.client.dto.CreateCertifyInput;
import org.beast.user.client.dto.EmailSignUpInput;
import org.beast.user.client.dto.GetUserIdByIdentityOutput;
import org.beast.user.client.dto.IVVerifyOutput;
import org.beast.user.client.dto.IdentityVerifyCreateInput;
import org.beast.user.client.dto.LoginOutput;
import org.beast.user.client.dto.MobileLoginInput;
import org.beast.user.client.dto.MobileSignUpInput;
import org.beast.user.client.dto.PwdLoginInput;
import org.beast.user.client.dto.SNSBindInput;
import org.beast.user.client.dto.SNSLoginInput;
import org.beast.user.client.dto.SNSUnbindInput;
import org.beast.user.client.dto.SendMobileCodeInput;
import org.beast.user.client.dto.SetPasswordInput;
import org.beast.user.client.dto.UserIdentityOutput;
import org.beast.user.client.dto.UserInput;
import org.beast.user.client.dto.UserOutput;
import org.beast.user.client.dto.UsernameSignUpInput;
import org.beast.user.client.dto.VerifyMobileCodeInput;
import org.beast.user.client.dto.VerifyMobileCodeOutput;
import org.beast.user.client.dto.VerifyUserPwdInput;
import org.beast.user.core.IdentityType;
import org.beast.user.user.data.IdentityCard;
import org.beast.user.user.data.UserBasicInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="beast-user-center")
public interface UserCenterClient {
    @PostMapping(value={"/apps/{app}/pwd-login"})
    public ReturnResult<LoginOutput> pwdLogin(@PathVariable(name="app") String var1, @RequestBody PwdLoginInput var2);

    @PostMapping(value={"/apps/{app}/mobile-login"})
    public ReturnResult<LoginOutput> mobileLogin(@PathVariable(name="app") String var1, @RequestBody MobileLoginInput var2);

    @PostMapping(value={"/apps/{app}/sns-login"})
    public ReturnResult<LoginOutput> snsLogin(@PathVariable(name="app") String var1, @RequestBody SNSLoginInput var2);

    @PostMapping(value={"/apps/{app}/mobile-signup"})
    public ReturnResult<?> mobileSignUp(@PathVariable(name="app") String var1, @RequestBody MobileSignUpInput var2);

    @PostMapping(value={"/apps/{app}/email-signup"})
    public ReturnResult<?> emailSignUp(@PathVariable(name="app") String var1, @RequestBody EmailSignUpInput var2);

    @PostMapping(value={"/apps/{app}/username-signup"})
    public ReturnResult<?> usernameSignUp(@PathVariable(name="app") String var1, @RequestBody UsernameSignUpInput var2);

    @PostMapping(value={"/apps/{app}/send-mobile-code"})
    public ReturnResult<?> sendMobileCode(@PathVariable(name="app") String var1, @RequestBody SendMobileCodeInput var2);

    @PostMapping(value={"/apps/{app}/verify-mobile-code"})
    public ReturnResult<VerifyMobileCodeOutput> verifyMobileCode(@PathVariable(name="app") String var1, @RequestBody VerifyMobileCodeInput var2);

    @PostMapping(value={"/apps/{app}/wechat-user-token/verify"})
    public ReturnResult<?> verify(@PathVariable(name="app") String var1, @RequestBody AppWechatUserTokenVerifyInput var2);

    @GetMapping(value={"/apps/{app}/getUserIdByIdentity"})
    public ReturnResult<GetUserIdByIdentityOutput> getUserIdByIdentity(@PathVariable(name="app") String var1, @RequestParam(value="identityType") IdentityType var2, @RequestParam(value="identifier") String var3);

    @PostMapping(value={"/apps/{app}/verifyUserPwd"})
    public ReturnResult<?> verifyUserPwd(@PathVariable(name="app") String var1, @RequestBody VerifyUserPwdInput var2);

    @GetMapping(value={"/apps/{app}/getIdentityByUid"})
    public ReturnResult<UserIdentityOutput> getIdentityByUid(@PathVariable(name="app") String var1, @RequestParam(value="uid") long var2, @RequestParam(value="identityType") IdentityType var4);

    @GetMapping(value={"/apps/{app}/getIdentitiesByUid"})
    public ReturnResult<List<UserIdentityOutput>> getIdentitiesByUid(@PathVariable(name="app") String var1, @RequestParam(value="uid") long var2, @RequestParam(value="identityTypes") List<IdentityType> var4);

    @GetMapping(value={"/apps/{app}/users/{uid}"})
    public ReturnResult<UserOutput> getUserBy(@PathVariable(name="app") String var1, @PathVariable(value="uid") long var2);

    @PutMapping(value={"/apps/{app}/users/{uid}"})
    public ReturnResult<?> updateUserBy(@PathVariable(name="app") String var1, @PathVariable(value="uid") long var2, @RequestBody UserInput var4);

    @PatchMapping(value={"/apps/{app}/users/{uid}"})
    public ReturnResult<?> patchUserBy(@PathVariable(name="app") String var1, @PathVariable(value="uid") long var2, @RequestBody UserInput var4);

    @GetMapping(value={"/apps/{app}/users/{uid}/basic-info"})
    public ReturnResult<UserBasicInfo> getBasicInfoBy(@PathVariable(name="app") String var1, @PathVariable(value="uid") long var2);

    @GetMapping(value={"/apps/{app}/users/{uid}/identity-card"})
    public ReturnResult<IdentityCard> getIdentityCardByUid(@PathVariable(name="app") String var1, @PathVariable(value="uid") long var2);

    @PostMapping(value={"/apps/{app}/iv/identity-verify"})
    public ReturnResult<IVVerifyOutput> createIdentityVerify(@PathVariable(name="app") String var1, @RequestBody IdentityVerifyCreateInput var2);

    @PostMapping(value={"/apps/{app}/account/password"})
    public ReturnResult<?> setPassword(@PathVariable(name="app") String var1, @RequestBody SetPasswordInput var2);

    @PostMapping(value={"/apps/{app}/account/mobile"})
    public ReturnResult<?> setMobile(@PathVariable(name="app") String var1, @RequestBody BindMobileInput var2);

    @PostMapping(value={"/apps/{app}/account/email"})
    public ReturnResult<?> setEmail(@PathVariable(name="app") String var1, @RequestBody BindEmailInput var2);

    @PostMapping(value={"/apps/{app}/users/{userId}/certify"})
    public ReturnResult<?> createCertify(@PathVariable(name="app") String var1, @PathVariable(name="userId") long var2, @RequestBody CreateCertifyInput var4);

    @PostMapping(value={"/apps/{app}/account/sns-bind"})
    public ReturnResult<?> snsBind(@PathVariable(name="app") String var1, @RequestBody SNSBindInput var2);

    @PostMapping(value={"/apps/{app}/account/sns-unbind"})
    public ReturnResult<?> snsUnbind(@PathVariable(name="app") String var1, @RequestBody SNSUnbindInput var2);
}

