/*
 * Decompiled with CFR 0.152.
 */
package org.beast.sns.wechat.data;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class ClientCredential {
    private String appId;
    private String accessToken;
    private long expiresIn;
    private Instant expiresAt;
    private Instant issuedAt;

    public boolean isExpired() {
        return Objects.isNull(this.expiresAt) || Instant.now().isAfter(this.expiresAt);
    }

    public boolean validate() {
        return !this.isExpired();
    }

    public Duration getRemainingTTL() {
        return Duration.between(Instant.now(), this.expiresAt);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }
}

