package org.beast.sns.wechat.data;

import lombok.Getter;
import lombok.Setter;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

@Getter @Setter
public class ClientCredential {

    private String appId;

    private String accessToken;

    /**
     * 有效时间 单位秒
     */
    private long expiresIn;


    /**
     * 过期时间
     */
    private Instant expiresAt;
    /**
     * 发行于
     */
    private Instant issuedAt;


    public boolean isExpired() {
        return Objects.isNull(expiresAt) || Instant.now().isAfter(expiresAt);
    }

    public boolean validate() {
        return !isExpired();
    }

    /**
     * @return second
     */
    public Duration getRemainingTTL() {
        return Duration.between(Instant.now(), this.expiresAt);
    }
}
