package org.beast.sns.wechat.data;

import lombok.Getter;
import lombok.Setter;

import java.time.Duration;
import java.time.Instant;

@Getter @Setter
public class ClientCredential {

    private String appId;

    private String accessToken;

    private long expireIn;

    /**
     * 过期时间
     */
    private Instant expireAt;

    /**
     * 创建于
     */
    private Instant createdAt;

    public boolean isExpire() {
        return Instant.now().isAfter(expireAt);
    }

    public boolean isValid() {
        return !isExpire();
    }

    /**
     * @return second
     */
    public Duration getRemainingTTL() {
        return Duration.between(Instant.now(), this.expireAt);
    }
}
