package org.beast.sns.bytedance.client;

import org.beast.data.message.ReturnResult;
import org.beast.sns.bytedance.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@FeignClient("beast-sns-bytedance")
public interface SNSBytedanceClient {

    @GetMapping("/api/apps/{app}")
    ReturnResult<BytedanceApp> app(
            @PathVariable("app") String app
    );

    @GetMapping("/api/apps/{app}/user-credential")
    ReturnResult<UserCredential> getUserCredential(
            @PathVariable("app") String app,
            @RequestParam("code") String code,
            @RequestParam("anonymousCode") String anonymousCode
    );

    @PostMapping("/api/apps/{app}/censor-text")
    ReturnResult<CensorPredict> censorText(
            @PathVariable("app") String app,
            @RequestBody() CensorTextInput input
    );

    @PostMapping("/api/apps/{app}/censor-image")
    ReturnResult<CensorPredict> censorImage(
            @PathVariable("app") String app,
            @RequestBody() CensorImageInput input
    );
}
