package org.beast.sns.bytedance.client;

import org.beast.data.message.ReturnResult;
import org.beast.sns.bytedance.client.dto.BytedanceApp;
import org.beast.sns.bytedance.client.dto.UserCredential;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient("beast-sns-bytedance")
public interface SNSBytedanceClient {

    @GetMapping("/api/apps/{app}")
    ReturnResult<BytedanceApp> app(
            @PathVariable("app") String app
    );

    @GetMapping("/api/apps/{app}/user-credential")
    ReturnResult<UserCredential> getUserCredential(
            @PathVariable("app") String app,
            @RequestParam("code") String code,
            @RequestParam("anonymousCode") String anonymousCode
    );
}
