package org.beast.hand.protocol.ws;

import org.springframework.core.convert.converter.Converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class WSMessageEncoder implements Converter<WSMessage, byte[]> {

    private static final char SP = ' ';
    @Override
    public byte[] convert(WSMessage source) {

        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StringBuilder requestLineBuilder = new StringBuilder();
        requestLineBuilder.append(source.getType());
        requestLineBuilder.append(SP);
        requestLineBuilder.append(source.getTarget());
        for (Map.Entry<String, String> header : source.getHeaders().entrySet()) {
            //编码
            requestLineBuilder.append(header.getKey());
            requestLineBuilder.append(':');
            requestLineBuilder.append(header.getValue());
            requestLineBuilder.append("\r\n");
        }
        try {
            os.write(requestLineBuilder.toString().getBytes(StandardCharsets.UTF_8));
            os.write('\r');
            os.write('\n');
            if (source.getBody() != null) {
                os.write(source.getBody());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }


        return os.toByteArray();
    }
}
