package org.beast.hand.protocol.ws;

import com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.springframework.core.convert.converter.Converter;

import javax.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class WSMessageDecoder implements Converter<byte[], WSMessage> {
    @Override
    public WSMessage convert(@Nonnull byte[] source) {
        try {
            WSMessageReader reader = new WSMessageReader(source);
            return new WSMessage(
                    WSType.valueOf(reader.type()),
                    reader.target(),
                    reader.headers(),
                    reader.body()
            );
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class WSMessageReader {
        private InputStream is;
        private String startLine;
        private String type;
        private String target;
        private Map<String, String> headers;
        private byte[] body;

        public WSMessageReader(byte[] bytes) throws IOException {
            this.is = new ByteArrayInputStream(bytes);
            parse();
        }

        private String readLine() throws IOException {
            StringBuffer lineBuffer = null;
            boolean eol = false;
            boolean skipLF = false;
            while(!eol) {
                int next = this.is.read();
                if (next == -1) {
                    return null;
                }
                if (lineBuffer == null) {
                    lineBuffer = new StringBuffer();
                }
                if (skipLF) {
                    if (next == '\n') {
                        eol = true;
                    } else {
                        lineBuffer.append('\r');
                        lineBuffer.append((char) next);
                    }
                } else if (next == '\r') {
                    skipLF = true;
                } else {
                    lineBuffer.append((char) next);
                }

            }
            return lineBuffer.toString();
        }

        public void parse() throws IOException {
            this.startLine = this.readLine();
            if (startLine == null) {
                throw new IOException("格式错误");
            }
            int index = startLine.indexOf(" ");
            if (index == -1) {
                this.type = startLine;
                this.target = null;
            } else {
                this.type = startLine.substring(0, index);
                this.target = startLine.substring(index + 1);
            }


            Map<String, String> headers = Maps.newHashMap();
            String line = null;
            while((line = this.readLine()) != null) {
                if (line.isEmpty()) {
                    break;
                }
                index = line.indexOf(":");
                String key = null;
                String value = null;
                if (index == -1 ) {
                    key = line;
                    value = "";
                } else {
                    key = line.substring(0, index);
                    value = line.substring(index + 1);
                }

                headers.put(key, value);
            }
            this.headers = headers;
            this.body = IOUtils.toByteArray(this.is);
            //IOUtils.toString(this.is, Charsets.UTF_8);
        }


        public String requestLine() {
            //先简单实现
            return this.startLine;
        }

        public String type() {
            return this.type;
        }
        public String target() {
            return this.target;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public byte[] body() {
            return this.body;
        }
    }
}
