package org.beast.comm.client;



import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient("beast-comm-server")
public interface CommClient {


    @PostMapping(value = "/app/api/messages", consumes = {MediaType.APPLICATION_JSON_VALUE})
    ReturnResult<?> send(
            @RequestBody MessageSendInput input
    );

}
