/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.resolver;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSType;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatOffiaccountSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.annotation.SNSUserTokenValue;
import org.beast.security.web.resolver.AbstractArgumentResolver;
import org.beast.security.web.resolver.SNSUserTokenWebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class SNSUserTokenArgumentResolver
extends AbstractArgumentResolver<SNSUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(SNSUserTokenArgumentResolver.class);
    private SNSUserTokenWebExtractor snsUserTokenWebExtractor = new SNSUserTokenWebExtractor();

    public SNSUserTokenArgumentResolver() {
        super(SNSUserTokenValue.class);
    }

    @Override
    public boolean isRequired(SNSUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new AccessDeniedException("SNSUserToken is required");
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    public SNSUserTokenValue resolveAnnotation(MethodParameter parameter) {
        return (SNSUserTokenValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), SNSUserTokenValue.class);
    }

    @Override
    protected Object resolveValue(SNSUserTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        SNSUserToken snsUserToken = this.snsUserTokenWebExtractor.extract(parameter, webRequest);
        if (Objects.isNull(snsUserToken)) {
            return null;
        }
        Object[] requiredTypes = annotation.type();
        if (requiredTypes.length > 0 && !ArrayUtils.contains((Object[])requiredTypes, (Object)snsUserToken.getType())) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return switch (snsUserToken.getType()) {
                case SNSType.WECHAT_WEAPP -> ((WechatWeappSNSUserToken)snsUserToken).getOpenid();
                case SNSType.WECHAT_OFFIACCOUNT -> ((WechatOffiaccountSNSUserToken)snsUserToken).getOpenid();
                case SNSType.BYTEDANCE_BYTEAPP -> ((BytedanceByteappSNSUserToken)snsUserToken).getOpenid();
                default -> null;
            };
        }
        return snsUserToken;
    }
}

