/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.beast.security.core.UserToken;
import org.beast.security.web.context.UserAuthorizationToken;
import org.beast.security.web.resolver.UserTokenWebExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public class UserSecurityContextRepository
implements SecurityContextRepository {
    private static final Logger log = LoggerFactory.getLogger(UserSecurityContextRepository.class);
    private UserTokenWebExtractor userTokenWebExtractor = new UserTokenWebExtractor();

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest servletRequest = requestResponseHolder.getRequest();
        UserToken userToken = this.userTokenWebExtractor.extract(servletRequest);
        if (Objects.isNull(userToken)) {
            return SecurityContextHolder.createEmptyContext();
        }
        UserAuthorizationToken authentication = new UserAuthorizationToken(userToken);
        authentication.setAuthenticated(true);
        return new SecurityContextImpl((Authentication)authentication);
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
    }

    public boolean containsContext(HttpServletRequest request) {
        UserToken userToken = this.userTokenWebExtractor.extract(request);
        return Objects.nonNull(userToken);
    }
}

