/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.web.access;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.IError;
import org.beast.data.message.StandardErrors;
import org.beast.web.servlet.error.AbstractExceptionAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class AccessHandlerExceptionAdvice
extends AbstractExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(AccessHandlerExceptionAdvice.class);
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public AccessHandlerExceptionAdvice(ErrorMessageSource errorMessageSource) {
        super(errorMessageSource);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ModelAndView handleAccessDeniedException(AccessDeniedException exception, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.warn("AccessDenied: {} message: {}", (Object)this.getRequestInfo(request), (Object)exception.getMessage());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean isAnonymous = this.authenticationTrustResolver.isAnonymous(authentication);
        if (isAnonymous) {
            return this.returnErrorMessage((IError)StandardErrors.UNAUTHENTICATED.toError(), request, response);
        }
        return this.returnErrorMessage((IError)StandardErrors.ACCESS_DENIED.toError(), request, response);
    }
}

