package org.beast.security.web.resolver;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;

public interface WebExtractor<T> {

    default T extract(MethodParameter parameter, NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        return this.extract(servletRequest);
    }

    T extract(HttpServletRequest servletRequest);
}
