package org.beast.security.web.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.UserToken;
import org.beast.security.core.codec.UserTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.security.core.annotation.UserTokenValue;
import org.beast.web.util.WebUtils;
import org.springframework.core.MethodParameter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

/**
 * @deprecated 应该使用spring-security这套
 */
@Deprecated
@Slf4j
public class UserTokenArgumentResolver extends AbstractTokenArgumentResolver<UserTokenValue>{

    private HeaderTokenValueWebExtractor headerTokenValueWebExtractor;
    private CookieTokenValueWebExtractor cookieTokenValueWebExtractor;

    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenArgumentResolver() {
        super(UserTokenValue.class);
        this.headerTokenValueWebExtractor = new HeaderTokenValueWebExtractor(WebUtils.HEADER_X_U_TOKEN);
        this.cookieTokenValueWebExtractor = new CookieTokenValueWebExtractor(WebUtils.COOKIE_U_TOKEN);
    }

    @Override
    public boolean isRequired(UserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new AccessDeniedException("token missing");
    }

    @Override
    protected Object resolveValue(UserTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        String tokenString = this.headerTokenValueWebExtractor.extract(parameter, webRequest);
        if (tokenString == null) {
            tokenString = this.cookieTokenValueWebExtractor.extract(parameter, webRequest);
        }
        if (ObjectUtils.isEmpty(tokenString)) {
            return null;
        }
        UserToken userToken;
        try {
            userToken = codec.decode(tokenString);
            userToken.verify();
        } catch (TokenException e) {
            log.warn("token exception", e);
            return null;
        } catch (Exception e) {
            log.warn("token invalid", e);
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return tokenString;
        }
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return userToken.getUid();
        }
        return userToken;
    }
}
