package org.beast.security.web.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.AnonymousToken;
import org.beast.security.core.codec.AnonymousTokenCodec;
import org.beast.security.core.exception.TokenException;
import org.beast.web.util.WebUtils;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;


@Slf4j
public class AnonymousTokenExtractor implements WebExtractor<AnonymousToken>{

//    public static final String COOKIE_NAME = "anonymous-token";
    private final static AnonymousTokenCodec CODEC = new AnonymousTokenCodec();
    private WebExtractor<String> tokenStringWebExtractor;

    public AnonymousTokenExtractor() {
        this.tokenStringWebExtractor = new CookieTokenValueWebExtractor(WebUtils.COOKIE_ANONYMOUS_TOKEN);
    }

    @Override
    public AnonymousToken extract(HttpServletRequest servletRequest) {
        String tokenString = tokenStringWebExtractor.extract(servletRequest);
        return parseToken(tokenString);
    }

    public AnonymousToken parseToken(String tokenString) {
        if (ObjectUtils.isEmpty(tokenString)) {
            return null;
        }

        AnonymousToken anonymousToken;
        try {
            anonymousToken = CODEC.decode(tokenString);
            anonymousToken.verify();
        } catch (TokenException e) {
            log.warn("AnonymousToken extract exception:  {}", tokenString, e);
            return null;
        } catch (Exception e) {
            log.warn("AnonymousToken extract failure: {}", tokenString, e);
            return null;
        }
        return anonymousToken;
    }
}
