package org.beast.security.web.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.AnonymousToken;
import org.beast.security.core.annotation.AnonymousTokenValue;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

import java.util.Objects;

@Slf4j
public class AnonymousTokenArgumentResolver extends AbstractTokenArgumentResolver<AnonymousTokenValue> {

    private AnonymousTokenExtractor anonymousTokenExtractor;
    public AnonymousTokenArgumentResolver() {
        super(AnonymousTokenValue.class);
        this.anonymousTokenExtractor = new AnonymousTokenExtractor();
    }

    @Override
    public boolean isRequired(AnonymousTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new IllegalArgumentException("anonymous-token is required");
    }

    @Nullable
    @Override
    protected Object resolveValue(AnonymousTokenValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        AnonymousToken anonymousToken = anonymousTokenExtractor.extract(parameter, webRequest);
        if (Objects.isNull(anonymousToken)) {
            return null;
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return anonymousToken.getAnonymousId();
        }
        return anonymousToken;
    }
}
