package org.beast.security.web.access;

import org.beast.data.message.ErrorMessageSource;
import org.beast.security.web.context.UserSecurityContextRepository;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.servlet.DispatcherServlet;

import javax.servlet.Servlet;

@Configuration(
        proxyBeanMethods = false
)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore({WebMvcAutoConfiguration.class, ErrorMvcAutoConfiguration.class})
public class SecurityWebMvcAutoConfiguration {

    @Bean
    public AccessHandlerExceptionAdvice accessHandlerExceptionAdvice(
            ErrorMessageSource errorMessageSource) {
        return new AccessHandlerExceptionAdvice(errorMessageSource);
    }


    @Bean
    public UserSecurityContextRepository userSecurityContextRepository() {
        return new UserSecurityContextRepository();
    }
}
